<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the page header div.
 *
 * @package Neve
 * @since   1.0.0
 */
?><!DOCTYPE html>
<?php

/**
 * Filters the header classes.
 *
 * @param string $header_classes Header classes.
 *
 * @since 2.3.7
 */
$header_classes = apply_filters( 'nv_header_classes', 'header' );

/**
 * Fires before the page is rendered.
 */
do_action( 'neve_html_start_before' );

?>
<html <?php language_attributes(); ?>>

<head>
	<?php
	/**
	 * Executes actions after the head tag is opened.
	 *
	 * @since 2.11
	 */
	do_action( 'neve_head_start_after' );
	?>

	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif; ?>
	<?php wp_head(); ?>
 
	<?php
	/**
	 * Executes actions before the head tag is closed.
	 *
	 * @since 2.11
	 */
    ?>
    <style>
        .wp-block-themeisle-blocks-advanced-columns {
            --background: transparent;
            --columns-width: 100%;
            --horizontal-align: unset;
            background: var(--background);
            justify-content: var(--horizontal-align);
            transition: .3s;
        }
    </style>
    <style id="otter-advanced-columns-style-inline-css">
        .wp-block-themeisle-blocks-advanced-columns-separators {
            position: absolute;
            left: 0;
            width: 100%;
            overflow-x: clip
        }

        .wp-block-themeisle-blocks-advanced-columns-separators.top {
            top: 0
        }

        .wp-block-themeisle-blocks-advanced-columns-separators.bottom {
            bottom: 0
        }

        .wp-block-themeisle-blocks-advanced-columns-separators.bottom svg {
            position: absolute;
            bottom: 0
        }

        .wp-block-themeisle-blocks-advanced-columns-separators svg {
            height: 100px
        }

        .wp-block-themeisle-blocks-advanced-columns-separators .rotate {
            transform: rotate(180deg)
        }

        html[lang=ja] .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap, html[lang=ko] .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap, html[lang=zh] .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap, html[lang=zh-Hans] .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap, html[lang=zh-Hant] .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap {
            word-break: normal
        }

        .wp-block-themeisle-blocks-advanced-columns {
            --background: transparent;
            --columns-width: 100%;
            --horizontal-align: unset;
            background: var(--background);
            justify-content: var(--horizontal-align);
            transition: .3s
        }

        .wp-block-themeisle-blocks-advanced-columns .wp-themeisle-block-overlay, .wp-block-themeisle-blocks-advanced-columns .wp-block-themeisle-blocks-advanced-columns-overlay {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0
        }

        .wp-block-themeisle-blocks-advanced-columns .wp-block-themeisle-blocks-advanced-column:only-child {
            max-width: var(--columns-width)
        }

        .wp-block-themeisle-blocks-advanced-columns .wp-block-themeisle-blocks-advanced-column {
            --background: transparent;
            --background-color-hover: var(--background);
            --link-color: inherit;
            background: var(--background);
            transition: .3s
        }

        .wp-block-themeisle-blocks-advanced-columns .wp-block-themeisle-blocks-advanced-column:hover {
            background: var(--background-color-hover)
        }

        .wp-block-themeisle-blocks-advanced-columns .wp-block-themeisle-blocks-advanced-column > * {
            position: relative
        }

        .wp-block-themeisle-blocks-advanced-columns .wp-block-themeisle-blocks-advanced-column .wp-block-themeisle-blocks-advanced-column-overlay {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0
        }

        .wp-block-themeisle-blocks-advanced-columns .wp-block-themeisle-blocks-advanced-column .wp-block-themeisle-blocks-slider {
            display: grid
        }

        .wp-block-themeisle-blocks-advanced-columns .wp-block-themeisle-blocks-advanced-column .aligncenter {
            margin-left: auto;
            margin-right: auto
        }

        .wp-block-themeisle-blocks-advanced-columns .wp-block-themeisle-blocks-advanced-column.has-dark-bg {
            color: var(--text-color, var(--nv-text-dark-bg, #fff))
        }

        .wp-block-themeisle-blocks-advanced-columns .wp-block-themeisle-blocks-advanced-column.has-light-bg {
            color: var(--text-color, var(--nv-text-color, #000))
        }

        .wp-block-themeisle-blocks-advanced-columns.has-default-gap .wp-block-themeisle-blocks-advanced-column {
            margin-left: 10px;
            margin-right: 10px
        }

        .wp-block-themeisle-blocks-advanced-columns.has-nogap-gap .wp-block-themeisle-blocks-advanced-column {
            margin-left: 0;
            margin-right: 0
        }

        .wp-block-themeisle-blocks-advanced-columns.has-narrow-gap .wp-block-themeisle-blocks-advanced-column {
            margin-left: 5px;
            margin-right: 5px
        }

        .wp-block-themeisle-blocks-advanced-columns.has-extended-gap .wp-block-themeisle-blocks-advanced-column {
            margin-left: 15px;
            margin-right: 15px
        }

        .wp-block-themeisle-blocks-advanced-columns.has-wide-gap .wp-block-themeisle-blocks-advanced-column {
            margin-left: 20px;
            margin-right: 20px
        }

        .wp-block-themeisle-blocks-advanced-columns.has-wider-gap .wp-block-themeisle-blocks-advanced-column {
            margin-left: 30px;
            margin-right: 30px
        }

        .wp-block-themeisle-blocks-advanced-columns.has-dark-bg {
            color: var(--text-color, var(--nv-text-dark-bg, #fff))
        }

        .wp-block-themeisle-blocks-advanced-columns.has-light-bg {
            color: var(--text-color, var(--nv-text-color, #000))
        }

        .wp-block-themeisle-blocks-advanced-columns > .innerblocks-wrap:not(:first-child,:last-child) {
            z-index: 1
        }

        @media (min-width: 960px) {
            .wp-block-themeisle-blocks-advanced-columns {
                display: flex;
                position: relative
            }

            .wp-block-themeisle-blocks-advanced-columns.has-vertical-flex-start > .innerblocks-wrap, .wp-block-themeisle-blocks-advanced-columns.has-vertical-top > .innerblocks-wrap {
                align-items: flex-start
            }

            .wp-block-themeisle-blocks-advanced-columns.has-vertical-center > .innerblocks-wrap {
                align-items: center
            }

            .wp-block-themeisle-blocks-advanced-columns.has-vertical-flex-end > .innerblocks-wrap, .wp-block-themeisle-blocks-advanced-columns.has-vertical-bottom > .innerblocks-wrap {
                align-items: flex-end
            }

            .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap {
                display: flex;
                flex-basis: 100%;
                word-break: keep-all;
                max-width: var(--columns-width)
            }

            .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap .wp-block-themeisle-blocks-advanced-column {
                position: relative
            }

            .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap .wp-block-themeisle-blocks-advanced-column:first-child {
                margin-left: 0
            }

            .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap .wp-block-themeisle-blocks-advanced-column:last-child {
                margin-right: 0
            }

            .wp-block-themeisle-blocks-advanced-columns.hide-in-desktop {
                display: none
            }

            .wp-block-themeisle-blocks-advanced-columns.has-1-columns.has-desktop-equal-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 100%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-2-columns.has-desktop-equal-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 50%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-2-columns.has-desktop-oneTwo-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 33.34%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-2-columns.has-desktop-oneTwo-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex-basis: 66.66%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-2-columns.has-desktop-twoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 33.34%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-2-columns.has-desktop-twoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex-basis: 66.66%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-desktop-equal-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 33.33%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-desktop-oneOneTwo-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 25%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-desktop-oneOneTwo-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex-basis: 50%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-desktop-twoOneOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 25%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-desktop-twoOneOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex-basis: 50%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-desktop-oneTwoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 50%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-desktop-oneTwoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex-basis: 25%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-desktop-oneTwoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex-basis: 25%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-desktop-oneThreeOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 60%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-desktop-oneThreeOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex-basis: 20%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-desktop-oneThreeOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex-basis: 20%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-4-columns.has-desktop-equal-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 25%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-5-columns.has-desktop-equal-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 20%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-6-columns.has-desktop-equal-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex-basis: 16.66%
            }
        }

        @media (min-width: 600px)and (max-width: 960px) {
            .wp-block-themeisle-blocks-advanced-columns {
                display: flex;
                position: relative
            }

            .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap {
                display: flex;
                flex-basis: 100%;
                word-break: keep-all;
                max-width: var(--columns-width)
            }

            .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap .wp-block-themeisle-blocks-advanced-column {
                position: relative;
                flex: 1
            }

            .wp-block-themeisle-blocks-advanced-columns.hide-in-tablet {
                display: none
            }

            .wp-block-themeisle-blocks-advanced-columns.has-2-columns.has-tablet-oneTwo-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex: 2
            }

            .wp-block-themeisle-blocks-advanced-columns.has-2-columns.has-tablet-twoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex: 2
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-tablet-oneOneTwo-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex: 2
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-tablet-twoOneOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex: 2
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-tablet-oneTwoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex: 2
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-tablet-oneTwoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex: 1
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-tablet-oneTwoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex: 1
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-tablet-oneThreeOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex: 3
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-tablet-oneThreeOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex: 1
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-tablet-oneThreeOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex: 1
            }

            .wp-block-themeisle-blocks-advanced-columns:not(.has-tablet-collapsedRows-layout).has-vertical-flex-start > .innerblocks-wrap, .wp-block-themeisle-blocks-advanced-columns:not(.has-tablet-collapsedRows-layout).has-vertical-top > .innerblocks-wrap {
                align-items: flex-start
            }

            .wp-block-themeisle-blocks-advanced-columns:not(.has-tablet-collapsedRows-layout).has-vertical-center > .innerblocks-wrap {
                align-items: center
            }

            .wp-block-themeisle-blocks-advanced-columns:not(.has-tablet-collapsedRows-layout).has-vertical-flex-end > .innerblocks-wrap, .wp-block-themeisle-blocks-advanced-columns:not(.has-tablet-collapsedRows-layout).has-vertical-bottom > .innerblocks-wrap {
                align-items: flex-end
            }

            .wp-block-themeisle-blocks-advanced-columns.has-tablet-collapsedRows-layout > .innerblocks-wrap {
                flex-direction: column
            }

            .wp-block-themeisle-blocks-advanced-columns.has-tablet-collapsedRows-layout.has-reverse-columns-tablet > .innerblocks-wrap {
                flex-direction: column-reverse
            }

            .wp-block-themeisle-blocks-advanced-columns.has-tablet-twoColumnGrid-layout > .innerblocks-wrap {
                display: flex;
                flex-wrap: wrap
            }

            .wp-block-themeisle-blocks-advanced-columns.has-tablet-twoColumnGrid-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex: 1 1 40%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-tablet-threeColumnGrid-layout > .innerblocks-wrap {
                display: flex;
                flex-wrap: wrap
            }

            .wp-block-themeisle-blocks-advanced-columns.has-tablet-threeColumnGrid-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex: 1 1 30%
            }
        }

        @media (max-width: 600px) {
            .wp-block-themeisle-blocks-advanced-columns {
                display: flex;
                position: relative
            }

            .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap {
                display: flex;
                flex-basis: 100%;
                word-break: keep-all;
                max-width: var(--columns-width)
            }

            .wp-block-themeisle-blocks-advanced-columns .innerblocks-wrap .wp-block-themeisle-blocks-advanced-column {
                position: relative;
                flex: 1
            }

            .wp-block-themeisle-blocks-advanced-columns.hide-in-mobile {
                display: none
            }

            .wp-block-themeisle-blocks-advanced-columns.has-2-columns.has-mobile-oneTwo-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex: 2
            }

            .wp-block-themeisle-blocks-advanced-columns.has-2-columns.has-mobile-twoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex: 2
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-mobile-oneOneTwo-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex: 2
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-mobile-twoOneOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex: 2
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-mobile-oneTwoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex: 2
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-mobile-oneTwoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex: 1
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-mobile-oneTwoOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex: 1
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-mobile-oneThreeOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex: 3
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-mobile-oneThreeOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:first-child {
                flex: 1
            }

            .wp-block-themeisle-blocks-advanced-columns.has-3-columns.has-mobile-oneThreeOne-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column:last-child {
                flex: 1
            }

            .wp-block-themeisle-blocks-advanced-columns:not(.has-mobile-collapsedRows-layout).has-vertical-flex-start > .innerblocks-wrap, .wp-block-themeisle-blocks-advanced-columns:not(.has-mobile-collapsedRows-layout).has-vertical-top > .innerblocks-wrap {
                align-items: flex-start
            }

            .wp-block-themeisle-blocks-advanced-columns:not(.has-mobile-collapsedRows-layout).has-vertical-center > .innerblocks-wrap {
                align-items: center
            }

            .wp-block-themeisle-blocks-advanced-columns:not(.has-mobile-collapsedRows-layout).has-vertical-flex-end > .innerblocks-wrap, .wp-block-themeisle-blocks-advanced-columns:not(.has-mobile-collapsedRows-layout).has-vertical-bottom > .innerblocks-wrap {
                align-items: flex-end
            }

            .wp-block-themeisle-blocks-advanced-columns.has-mobile-collapsedRows-layout > .innerblocks-wrap {
                flex-direction: column
            }

            .wp-block-themeisle-blocks-advanced-columns.has-mobile-collapsedRows-layout.has-reverse-columns-mobile > .innerblocks-wrap {
                flex-direction: column-reverse
            }

            .wp-block-themeisle-blocks-advanced-columns.has-mobile-twoColumnGrid-layout > .innerblocks-wrap {
                display: flex;
                flex-wrap: wrap
            }

            .wp-block-themeisle-blocks-advanced-columns.has-mobile-twoColumnGrid-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex: 1 1 40%
            }

            .wp-block-themeisle-blocks-advanced-columns.has-mobile-threeColumnGrid-layout > .innerblocks-wrap {
                display: flex;
                flex-wrap: wrap
            }

            .wp-block-themeisle-blocks-advanced-columns.has-mobile-threeColumnGrid-layout > .innerblocks-wrap > .wp-block-themeisle-blocks-advanced-column {
                flex: 1 1 30%
            }
        }

        /*# sourceMappingURL=style.css.map */

    </style>
    <style id="otter-advanced-heading-style-inline-css">
        span.wp-block-themeisle-blocks-advanced-heading {
            display: block
        }

        .wp-block-themeisle-blocks-advanced-heading {
            --padding: 0px;
            --padding-tablet: var(--padding);
            --padding-mobile: var(--padding-tablet);
            --margin: 0px 0px 25px 0px;
            --margin-tablet: var(--margin);
            --margin-mobile: var(--margin-tablet);
            --text-align: left;
            --text-align-tablet: var(--text-align);
            --text-align-mobile: var(--text-align-tablet);
            padding: var(--padding);
            margin: var(--margin);
            text-align: var(--text-align)
        }

        .wp-block-themeisle-blocks-advanced-heading.has-dark-bg {
            color: #fff
        }

        @media (min-width: 600px)and (max-width: 960px) {
            .wp-block-themeisle-blocks-advanced-heading {
                padding: var(--padding-tablet);
                margin: var(--margin-tablet);
                text-align: var(--text-align-tablet)
            }
        }

        @media (max-width: 600px) {
            .wp-block-themeisle-blocks-advanced-heading {
                padding: var(--padding-mobile);
                margin: var(--margin-mobile);
                text-align: var(--text-align-mobile)
            }
        }

        .wp-block-themeisle-blocks-advanced-heading.highlight {
            background-color: #ff0;
            color: #000
        }

        /*# sourceMappingURL=style.css.map */

    </style>
    <style id="otter-font-awesome-style-inline-css">
        .wp-block-themeisle-blocks-font-awesome-icons {
            --align: center;
            --align-tablet: var(--align);
            --align-mobile: var(--align-tablet);
            --border-color: inherit;
            --border-size: unset;
            --border-radius: 0%;
            --margin: 5px;
            --padding: 5px;
            --font-size: 16px;
            display: flex;
            justify-content: var(--align);
            margin: 0
        }

        .wp-block-themeisle-blocks-font-awesome-icons .wp-block-themeisle-blocks-font-awesome-icons-container {
            display: inline-flex;
            justify-content: center;
            border: var(--border-size) solid;
            border-color: var(--border-color);
            border-radius: var(--border-radius);
            margin: var(--margin);
            font-size: var(--font-size);
            text-align: center;
            align-items: center;
            box-sizing: content-box
        }

        .wp-block-themeisle-blocks-font-awesome-icons .wp-block-themeisle-blocks-font-awesome-icons-container:not(.nan-padding) {
            width: calc(var(--font-size) * 1.5 + var(--padding));
            height: calc(var(--font-size) * 1.5 + var(--padding))
        }

        .wp-block-themeisle-blocks-font-awesome-icons .wp-block-themeisle-blocks-font-awesome-icons-container:not(.nan-padding) i {
            font-size: var(--font-size)
        }

        .wp-block-themeisle-blocks-font-awesome-icons .wp-block-themeisle-blocks-font-awesome-icons-container.nan-padding {
            padding: var(--padding);
            aspect-ratio: 1
        }

        .wp-block-themeisle-blocks-font-awesome-icons .wp-block-themeisle-blocks-font-awesome-icons-container.nan-padding i {
            font-size: calc(var(--font-size) / 1.25);
            width: var(--font-size)
        }

        .wp-block-themeisle-blocks-font-awesome-icons .wp-block-themeisle-blocks-font-awesome-icons-container svg {
            width: var(--font-size);
            height: var(--font-size);
            fill: currentColor
        }

        @media (max-width: 960px) {
            .wp-block-themeisle-blocks-font-awesome-icons {
                justify-content: var(--align-tablet)
            }
        }

        @media (max-width: 600px) {
            .wp-block-themeisle-blocks-font-awesome-icons {
                justify-content: var(--align-mobile)
            }
        }

        /*# sourceMappingURL=style.css.map */

    </style>
    <style id="classic-theme-styles-inline-css">
        /*! This file is auto-generated */
        .wp-block-button__link {
            color: #fff;
            background-color: #32373c;
            border-radius: 9999px;
            box-shadow: none;
            text-decoration: none;
            padding: calc(.667em + 2px) calc(1.333em + 2px);
            font-size: 1.125em
        }

        .wp-block-file__button {
            background: #32373c;
            color: #fff;
            text-decoration: none
        }
    </style>
    <style id="global-styles-inline-css">
        body {
            --wp--preset--color--black: #000000;
            --wp--preset--color--cyan-bluish-gray: #abb8c3;
            --wp--preset--color--white: #ffffff;
            --wp--preset--color--pale-pink: #f78da7;
            --wp--preset--color--vivid-red: #cf2e2e;
            --wp--preset--color--luminous-vivid-orange: #ff6900;
            --wp--preset--color--luminous-vivid-amber: #fcb900;
            --wp--preset--color--light-green-cyan: #7bdcb5;
            --wp--preset--color--vivid-green-cyan: #00d084;
            --wp--preset--color--pale-cyan-blue: #8ed1fc;
            --wp--preset--color--vivid-cyan-blue: #0693e3;
            --wp--preset--color--vivid-purple: #9b51e0;
            --wp--preset--color--neve-link-color: var(--nv-primary-accent);
            --wp--preset--color--neve-link-hover-color: var(--nv-secondary-accent);
            --wp--preset--color--nv-site-bg: var(--nv-site-bg);
            --wp--preset--color--nv-light-bg: var(--nv-light-bg);
            --wp--preset--color--nv-dark-bg: var(--nv-dark-bg);
            --wp--preset--color--neve-text-color: var(--nv-text-color);
            --wp--preset--color--nv-text-dark-bg: var(--nv-text-dark-bg);
            --wp--preset--color--nv-c-1: var(--nv-c-1);
            --wp--preset--color--nv-c-2: var(--nv-c-2);
            --wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg, rgba(6, 147, 227, 1) 0%, rgb(155, 81, 224) 100%);
            --wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg, rgb(122, 220, 180) 0%, rgb(0, 208, 130) 100%);
            --wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg, rgba(252, 185, 0, 1) 0%, rgba(255, 105, 0, 1) 100%);
            --wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg, rgba(255, 105, 0, 1) 0%, rgb(207, 46, 46) 100%);
            --wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg, rgb(238, 238, 238) 0%, rgb(169, 184, 195) 100%);
            --wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg, rgb(74, 234, 220) 0%, rgb(151, 120, 209) 20%, rgb(207, 42, 186) 40%, rgb(238, 44, 130) 60%, rgb(251, 105, 98) 80%, rgb(254, 248, 76) 100%);
            --wp--preset--gradient--blush-light-purple: linear-gradient(135deg, rgb(255, 206, 236) 0%, rgb(152, 150, 240) 100%);
            --wp--preset--gradient--blush-bordeaux: linear-gradient(135deg, rgb(254, 205, 165) 0%, rgb(254, 45, 45) 50%, rgb(107, 0, 62) 100%);
            --wp--preset--gradient--luminous-dusk: linear-gradient(135deg, rgb(255, 203, 112) 0%, rgb(199, 81, 192) 50%, rgb(65, 88, 208) 100%);
            --wp--preset--gradient--pale-ocean: linear-gradient(135deg, rgb(255, 245, 203) 0%, rgb(182, 227, 212) 50%, rgb(51, 167, 181) 100%);
            --wp--preset--gradient--electric-grass: linear-gradient(135deg, rgb(202, 248, 128) 0%, rgb(113, 206, 126) 100%);
            --wp--preset--gradient--midnight: linear-gradient(135deg, rgb(2, 3, 129) 0%, rgb(40, 116, 252) 100%);
            --wp--preset--font-size--small: 13px;
            --wp--preset--font-size--medium: 20px;
            --wp--preset--font-size--large: 36px;
            --wp--preset--font-size--x-large: 42px;
            --wp--preset--spacing--20: 0.44rem;
            --wp--preset--spacing--30: 0.67rem;
            --wp--preset--spacing--40: 1rem;
            --wp--preset--spacing--50: 1.5rem;
            --wp--preset--spacing--60: 2.25rem;
            --wp--preset--spacing--70: 3.38rem;
            --wp--preset--spacing--80: 5.06rem;
            --wp--preset--shadow--natural: 6px 6px 9px rgba(0, 0, 0, 0.2);
            --wp--preset--shadow--deep: 12px 12px 50px rgba(0, 0, 0, 0.4);
            --wp--preset--shadow--sharp: 6px 6px 0px rgba(0, 0, 0, 0.2);
            --wp--preset--shadow--outlined: 6px 6px 0px -3px rgba(255, 255, 255, 1), 6px 6px rgba(0, 0, 0, 1);
            --wp--preset--shadow--crisp: 6px 6px 0px rgba(0, 0, 0, 1);
        }

        :where(.is-layout-flex) {
            gap: 0.5em;
        }

        :where(.is-layout-grid) {
            gap: 0.5em;
        }

        body .is-layout-flex {
            display: flex;
        }

        body .is-layout-flex {
            flex-wrap: wrap;
            align-items: center;
        }

        body .is-layout-flex > * {
            margin: 0;
        }

        body .is-layout-grid {
            display: grid;
        }

        body .is-layout-grid > * {
            margin: 0;
        }

        :where(.wp-block-columns.is-layout-flex) {
            gap: 2em;
        }

        :where(.wp-block-columns.is-layout-grid) {
            gap: 2em;
        }

        :where(.wp-block-post-template.is-layout-flex) {
            gap: 1.25em;
        }

        :where(.wp-block-post-template.is-layout-grid) {
            gap: 1.25em;
        }

        .has-black-color {
            color: var(--wp--preset--color--black) !important;
        }

        .has-cyan-bluish-gray-color {
            color: var(--wp--preset--color--cyan-bluish-gray) !important;
        }

        .has-white-color {
            color: var(--wp--preset--color--white) !important;
        }

        .has-pale-pink-color {
            color: var(--wp--preset--color--pale-pink) !important;
        }

        .has-vivid-red-color {
            color: var(--wp--preset--color--vivid-red) !important;
        }

        .has-luminous-vivid-orange-color {
            color: var(--wp--preset--color--luminous-vivid-orange) !important;
        }

        .has-luminous-vivid-amber-color {
            color: var(--wp--preset--color--luminous-vivid-amber) !important;
        }

        .has-light-green-cyan-color {
            color: var(--wp--preset--color--light-green-cyan) !important;
        }

        .has-vivid-green-cyan-color {
            color: var(--wp--preset--color--vivid-green-cyan) !important;
        }

        .has-pale-cyan-blue-color {
            color: var(--wp--preset--color--pale-cyan-blue) !important;
        }

        .has-vivid-cyan-blue-color {
            color: var(--wp--preset--color--vivid-cyan-blue) !important;
        }

        .has-vivid-purple-color {
            color: var(--wp--preset--color--vivid-purple) !important;
        }

        .has-neve-link-color-color {
            color: var(--wp--preset--color--neve-link-color) !important;
        }

        .has-neve-link-hover-color-color {
            color: var(--wp--preset--color--neve-link-hover-color) !important;
        }

        .has-nv-site-bg-color {
            color: var(--wp--preset--color--nv-site-bg) !important;
        }

        .has-nv-light-bg-color {
            color: var(--wp--preset--color--nv-light-bg) !important;
        }

        .has-nv-dark-bg-color {
            color: var(--wp--preset--color--nv-dark-bg) !important;
        }

        .has-neve-text-color-color {
            color: var(--wp--preset--color--neve-text-color) !important;
        }

        .has-nv-text-dark-bg-color {
            color: var(--wp--preset--color--nv-text-dark-bg) !important;
        }

        .has-nv-c-1-color {
            color: var(--wp--preset--color--nv-c-1) !important;
        }

        .has-nv-c-2-color {
            color: var(--wp--preset--color--nv-c-2) !important;
        }

        .has-black-background-color {
            background-color: var(--wp--preset--color--black) !important;
        }

        .has-cyan-bluish-gray-background-color {
            background-color: var(--wp--preset--color--cyan-bluish-gray) !important;
        }

        .has-white-background-color {
            background-color: var(--wp--preset--color--white) !important;
        }

        .has-pale-pink-background-color {
            background-color: var(--wp--preset--color--pale-pink) !important;
        }

        .has-vivid-red-background-color {
            background-color: var(--wp--preset--color--vivid-red) !important;
        }

        .has-luminous-vivid-orange-background-color {
            background-color: var(--wp--preset--color--luminous-vivid-orange) !important;
        }

        .has-luminous-vivid-amber-background-color {
            background-color: var(--wp--preset--color--luminous-vivid-amber) !important;
        }

        .has-light-green-cyan-background-color {
            background-color: var(--wp--preset--color--light-green-cyan) !important;
        }

        .has-vivid-green-cyan-background-color {
            background-color: var(--wp--preset--color--vivid-green-cyan) !important;
        }

        .has-pale-cyan-blue-background-color {
            background-color: var(--wp--preset--color--pale-cyan-blue) !important;
        }

        .has-vivid-cyan-blue-background-color {
            background-color: var(--wp--preset--color--vivid-cyan-blue) !important;
        }

        .has-vivid-purple-background-color {
            background-color: var(--wp--preset--color--vivid-purple) !important;
        }

        .has-neve-link-color-background-color {
            background-color: var(--wp--preset--color--neve-link-color) !important;
        }

        .has-neve-link-hover-color-background-color {
            background-color: var(--wp--preset--color--neve-link-hover-color) !important;
        }

        .has-nv-site-bg-background-color {
            background-color: var(--wp--preset--color--nv-site-bg) !important;
        }

        .has-nv-light-bg-background-color {
            background-color: var(--wp--preset--color--nv-light-bg) !important;
        }

        .has-nv-dark-bg-background-color {
            background-color: var(--wp--preset--color--nv-dark-bg) !important;
        }

        .has-neve-text-color-background-color {
            background-color: var(--wp--preset--color--neve-text-color) !important;
        }

        .has-nv-text-dark-bg-background-color {
            background-color: var(--wp--preset--color--nv-text-dark-bg) !important;
        }

        .has-nv-c-1-background-color {
            background-color: var(--wp--preset--color--nv-c-1) !important;
        }

        .has-nv-c-2-background-color {
            background-color: var(--wp--preset--color--nv-c-2) !important;
        }

        .has-black-border-color {
            border-color: var(--wp--preset--color--black) !important;
        }

        .has-cyan-bluish-gray-border-color {
            border-color: var(--wp--preset--color--cyan-bluish-gray) !important;
        }

        .has-white-border-color {
            border-color: var(--wp--preset--color--white) !important;
        }

        .has-pale-pink-border-color {
            border-color: var(--wp--preset--color--pale-pink) !important;
        }

        .has-vivid-red-border-color {
            border-color: var(--wp--preset--color--vivid-red) !important;
        }

        .has-luminous-vivid-orange-border-color {
            border-color: var(--wp--preset--color--luminous-vivid-orange) !important;
        }

        .has-luminous-vivid-amber-border-color {
            border-color: var(--wp--preset--color--luminous-vivid-amber) !important;
        }

        .has-light-green-cyan-border-color {
            border-color: var(--wp--preset--color--light-green-cyan) !important;
        }

        .has-vivid-green-cyan-border-color {
            border-color: var(--wp--preset--color--vivid-green-cyan) !important;
        }

        .has-pale-cyan-blue-border-color {
            border-color: var(--wp--preset--color--pale-cyan-blue) !important;
        }

        .has-vivid-cyan-blue-border-color {
            border-color: var(--wp--preset--color--vivid-cyan-blue) !important;
        }

        .has-vivid-purple-border-color {
            border-color: var(--wp--preset--color--vivid-purple) !important;
        }

        .has-neve-link-color-border-color {
            border-color: var(--wp--preset--color--neve-link-color) !important;
        }

        .has-neve-link-hover-color-border-color {
            border-color: var(--wp--preset--color--neve-link-hover-color) !important;
        }

        .has-nv-site-bg-border-color {
            border-color: var(--wp--preset--color--nv-site-bg) !important;
        }

        .has-nv-light-bg-border-color {
            border-color: var(--wp--preset--color--nv-light-bg) !important;
        }

        .has-nv-dark-bg-border-color {
            border-color: var(--wp--preset--color--nv-dark-bg) !important;
        }

        .has-neve-text-color-border-color {
            border-color: var(--wp--preset--color--neve-text-color) !important;
        }

        .has-nv-text-dark-bg-border-color {
            border-color: var(--wp--preset--color--nv-text-dark-bg) !important;
        }

        .has-nv-c-1-border-color {
            border-color: var(--wp--preset--color--nv-c-1) !important;
        }

        .has-nv-c-2-border-color {
            border-color: var(--wp--preset--color--nv-c-2) !important;
        }

        .has-vivid-cyan-blue-to-vivid-purple-gradient-background {
            background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;
        }

        .has-light-green-cyan-to-vivid-green-cyan-gradient-background {
            background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;
        }

        .has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background {
            background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;
        }

        .has-luminous-vivid-orange-to-vivid-red-gradient-background {
            background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;
        }

        .has-very-light-gray-to-cyan-bluish-gray-gradient-background {
            background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;
        }

        .has-cool-to-warm-spectrum-gradient-background {
            background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;
        }

        .has-blush-light-purple-gradient-background {
            background: var(--wp--preset--gradient--blush-light-purple) !important;
        }

        .has-blush-bordeaux-gradient-background {
            background: var(--wp--preset--gradient--blush-bordeaux) !important;
        }

        .has-luminous-dusk-gradient-background {
            background: var(--wp--preset--gradient--luminous-dusk) !important;
        }

        .has-pale-ocean-gradient-background {
            background: var(--wp--preset--gradient--pale-ocean) !important;
        }

        .has-electric-grass-gradient-background {
            background: var(--wp--preset--gradient--electric-grass) !important;
        }

        .has-midnight-gradient-background {
            background: var(--wp--preset--gradient--midnight) !important;
        }

        .has-small-font-size {
            font-size: var(--wp--preset--font-size--small) !important;
        }

        .has-medium-font-size {
            font-size: var(--wp--preset--font-size--medium) !important;
        }

        .has-large-font-size {
            font-size: var(--wp--preset--font-size--large) !important;
        }

        .has-x-large-font-size {
            font-size: var(--wp--preset--font-size--x-large) !important;
        }

        .wp-block-navigation a:where(:not(.wp-element-button)) {
            color: inherit;
        }

        :where(.wp-block-post-template.is-layout-flex) {
            gap: 1.25em;
        }

        :where(.wp-block-post-template.is-layout-grid) {
            gap: 1.25em;
        }

        :where(.wp-block-columns.is-layout-flex) {
            gap: 2em;
        }

        :where(.wp-block-columns.is-layout-grid) {
            gap: 2em;
        }

        .wp-block-pullquote {
            font-size: 1.5em;
            line-height: 1.6;
        }
    </style>

    <style id="neve-style-inline-css">
        .page .neve-main, .single:not(.single-product) .neve-main {
            margin: var(--c-vspace)
        }

        .nv-meta-list li.meta:not(:last-child):after {
            content: "/"
        }

        .nv-meta-list .no-mobile {
            display: none;
        }

        .nv-meta-list li.last::after {
            content: "" !important;
        }

        @media (min-width: 769px) {
            .nv-meta-list .no-mobile {
                display: inline-block;
            }

            .nv-meta-list li.last:not(:last-child)::after {
                content: "/" !important;
            }
        }

        .nav-ul li .caret svg, .nav-ul li .caret img {
            width: var(--smiconsize, 0.5em);
            height: var(--smiconsize, 0.5em);
        }

        .nv-menu-animation-fade:not(.menu-mobile) > .menu-item > .sub-menu, .nv-menu-animation-fade:not(.menu-mobile) > .menu-item > .sub-menu .sub-menu {
            opacity: 0;
            visibility: hidden;
            transition: opacity ease-in-out .3s;
        }

        .nv-menu-animation-fade:not(.menu-mobile) > .menu-item:focus > .sub-menu, .nv-menu-animation-fade:not(.menu-mobile) > .menu-item:hover > .sub-menu, .nv-menu-animation-fade:not(.menu-mobile) > .menu-item .menu-item:focus > .sub-menu, .nv-menu-animation-fade:not(.menu-mobile) > .menu-item .menu-item:hover > .sub-menu {
            opacity: 1;
            visibility: visible;
            transition: opacity ease-in-out .3s;
        }

        .nav-ul .sub-menu {
            right: var(--alignment);
            border-style: var(--bstyle);
            border-radius: var(--bradius, 0);
            border-width: var(--bwidth, 0);
            border-color: var(--bcolor);
            background: var(--bgcolor) !important;
        }

        .nav-ul .sub-menu li {
            border-style: var(--itembstyle);
        }

        .nav-ul .sub-menu li:not(:last-child) {
            margin-bottom: var(--spacebetween);
        }

        :root {
            --container: 748px;
            --postwidth: 100%;
            --primarybtnbg: var(--nv-primary-accent);
            --primarybtnhoverbg: var(--nv-primary-accent);
            --primarybtncolor: #fff;
            --secondarybtncolor: var(--nv-primary-accent);
            --primarybtnhovercolor: #fff;
            --secondarybtnhovercolor: var(--nv-primary-accent);
            --primarybtnborderradius: 999px;
            --secondarybtnborderradius: 999px;
            --secondarybtnborderwidth: 3px;
            --btnpadding: 13px 15px;
            --primarybtnpadding: 13px 15px;
            --secondarybtnpadding: calc(13px - 3px) calc(15px - 3px);
            --bodyfontfamily: "Space Grotesk";
            --bodyfontsize: 15px;
            --bodylineheight: 1.6em;
            --bodyletterspacing: 0px;
            --bodyfontweight: 400;
            --bodytexttransform: none;
            --h1fontsize: 32px;
            --h1fontweight: 400;
            --h1lineheight: 1.2em;
            --h1letterspacing: 0px;
            --h1texttransform: none;
            --h2fontsize: 28px;
            --h2fontweight: 400;
            --h2lineheight: 1.3em;
            --h2letterspacing: 0px;
            --h2texttransform: none;
            --h3fontsize: 24px;
            --h3fontweight: 400;
            --h3lineheight: 1.4em;
            --h3letterspacing: 0px;
            --h3texttransform: none;
            --h4fontsize: 20px;
            --h4fontweight: 400;
            --h4lineheight: 1.6em;
            --h4letterspacing: 0px;
            --h4texttransform: none;
            --h5fontsize: 16px;
            --h5fontweight: 400;
            --h5lineheight: 1.6em;
            --h5letterspacing: 0px;
            --h5texttransform: none;
            --h6fontsize: 14px;
            --h6fontweight: 500;
            --h6lineheight: 1.6em;
            --h6letterspacing: 0px;
            --h6texttransform: none;
            --formfieldborderwidth: 2px;
            --formfieldborderradius: 3px;
            --formfieldbgcolor: var(--nv-site-bg);
            --formfieldbordercolor: #dddddd;
            --formfieldcolor: var(--nv-text-color);
            --formfieldpadding: 10px 12px;
        }

        .single-post-container .alignfull > [class*="__inner-container"], .single-post-container .alignwide > [class*="__inner-container"] {
            max-width: 718px
        }

        .nv-meta-list {
            --avatarsize: 20px;
        }

        .single .nv-meta-list {
            --avatarsize: 20px;
        }

        .blog .nv-meta-list li, .archive .nv-meta-list li {
            --fontweight: 600;
            --texttransform: uppercase;
        }

        .single h1.entry-title {
            --fontsize: 28px;
        }

        .single .nv-meta-list li {
            --fontweight: 600;
            --texttransform: uppercase;
        }

        .nv-post-cover {
            --height: 200px;
            --padding: 32px 24px;
            --justify: center;
            --textalign: center;
            --valign: center;
        }

        .nv-post-cover .nv-title-meta-wrap, .nv-page-title-wrap, .entry-header {
            --color: var(--nv-text-color);
            --textalign: center;
        }

        .nv-is-boxed.nv-title-meta-wrap {
            --padding: 40px 15px;
            --bgcolor: var(--nv-dark-bg);
        }

        .nv-overlay {
            --bgcolor: var(--nv-light-bg);
            --opacity: 100;
            --blendmode: normal;
        }

        .nv-is-boxed.nv-comments-wrap {
            --padding: 20px;
        }

        .nv-is-boxed.comment-respond {
            --padding: 20px;
        }

        .single:not(.single-product), .page {
            --c-vspace: 0 0 0 0;;
        }

        .global-styled {
            --bgcolor: var(--nv-site-bg);
        }

        .header-top {
            --rowbcolor: var(--nv-light-bg);
            --color: var(--nv-text-color);
            --bgcolor: var(--nv-site-bg);
        }

        .header-main {
            --rowbwidth: 0px;
            --rowbcolor: var(--nv-text-color);
            --color: var(--nv-text-color);
            --bgcolor: var(--nv-light-bg);
        }

        .header-bottom {
            --rowbcolor: var(--nv-light-bg);
            --color: var(--nv-text-color);
            --bgcolor: var(--nv-site-bg);
        }

        .header-menu-sidebar-bg {
            --justify: flex-start;
            --textalign: left;
            --flexg: 1;
            --wrapdropdownwidth: auto;
            --color: var(--nv-text-color);
            --bgcolor: var(--nv-site-bg);
        }

        .header-menu-sidebar {
            width: 360px;
        }

        .builder-item--logo {
            --maxwidth: 120px;
            --fs: 24px;
            --padding: 10px 0;
            --margin: 0;
            --textalign: left;
            --justify: flex-start;
        }

        .builder-item--nav-icon, .header-menu-sidebar .close-sidebar-panel .navbar-toggle {
            --borderradius: 5px;
            --borderwidth: 1px;
        }

        .builder-item--nav-icon {
            --label-margin: 0 5px 0 0;;
            --padding: 10px 15px;
            --margin: 0;
        }

        .builder-item--primary-menu {
            --hovercolor: var(--nv-text-color);
            --hovertextcolor: var(--nv-text-color);
            --activecolor: var(--nv-text-color);
            --spacing: 20px;
            --height: 25px;
            --smiconsize: 7px;
            --padding: 0;
            --margin: 0;
            --fontsize: 1em;
            --lineheight: 1.6em;
            --letterspacing: 0px;
            --fontweight: 400;
            --texttransform: none;
            --iconsize: 1em;
        }

        .builder-item--primary-menu .sub-menu {
            --alignment: auto;
            --justify: left;
            --spacebetween: 0px;
            --bstyle: solid;
            --bwidth: 0;
            --bradius: 0px;
            --bcolor: var(--nv-text-color);
            --bgcolor: var(--nv-site-bg);
            --itembstyle: none;
            --color: var(--nv-text-color);
            --hovercolor: var(--nv-primary-accent);
        }

        .hfg-is-group.has-primary-menu .inherit-ff {
            --inheritedfw: 400;
        }

        .builder-item--button_base {
            --primarybtnbg: var(--nv-dark-bg);
            --primarybtncolor: var(--nv-text-dark-bg);
            --primarybtnhoverbg: var(--nv-primary-accent);
            --primarybtnhovercolor: var(--nv-text-dark-bg);
            --primarybtnborderradius: 999px;
            --primarybtnshadow: none;
            --primarybtnhovershadow: none;
            --padding: 8px 12px;
            --margin: 0;
        }

        .builder-item--social_icons {
            --spacing: 10px;
            --borderradius: 5px;
            --iconpadding: 5px;
            --icon-size: 18px;
            --padding: 0;
            --margin: 0;
        }

        .footer-top-inner .row {
            grid-template-columns: 1fr 1fr 1fr;
            --valign: flex-start;
        }

        .footer-top {
            --rowbcolor: var(--nv-light-bg);
            --color: var(--nv-text-color);
            --bgcolor: var(--nv-site-bg);
        }

        .footer-main-inner .row {
            grid-template-columns: 2fr 1fr 1fr;
            --valign: flex-start;
        }

        .footer-main {
            --rowbwidth: 0px;
            --rowbcolor: var(--nv-text-color);
            --color: var(--nv-text-color);
            --bgcolor: var(--nv-light-bg);
        }

        .footer-bottom-inner .row {
            grid-template-columns: 1fr 1fr 1fr;
            --valign: center;
        }

        .footer-bottom {
            --rowbwidth: 0px;
            --rowbcolor: var(--nv-text-color);
            --color: var(--nv-text-dark-bg);
            --bgcolor: var(--nv-dark-bg);
        }

        .builder-item--footer-one-widgets {
            --padding: 40px 0 0 0;;
            --margin: 0;
            --textalign: left;
            --justify: flex-start;
        }

        .builder-item--footer-two-widgets {
            --padding: 20px 0 0 0;;
            --margin: 0;
            --textalign: left;
            --justify: flex-start;
        }

        .builder-item--footer-three-widgets {
            --padding: 20px 0 40px 0;;
            --margin: 0;
            --textalign: left;
            --justify: flex-start;
        }

        .builder-item--footer-menu {
            --hovercolor: var(--nv-primary-accent);
            --spacing: 20px;
            --height: 25px;
            --padding: 0 0 10px 0;;
            --margin: 0;
            --fontsize: 1em;
            --lineheight: 1.6em;
            --letterspacing: 0px;
            --fontweight: 700;
            --texttransform: uppercase;
            --iconsize: 1em;
            --textalign: left;
            --justify: flex-start;
        }

        .builder-item--footer_copyright {
            --padding: 10px 0 0 0;;
            --margin: 0;
            --fontsize: 1em;
            --lineheight: 1.6em;
            --letterspacing: 0px;
            --fontweight: 700;
            --texttransform: uppercase;
            --iconsize: 1em;
            --textalign: left;
            --justify: flex-start;
        }

        .page_header-top {
            --rowbcolor: var(--nv-light-bg);
            --color: var(--nv-text-color);
            --bgcolor: var(--nv-site-bg);
        }

        .page_header-bottom {
            --rowbcolor: var(--nv-light-bg);
            --color: var(--nv-text-color);
            --bgcolor: var(--nv-site-bg);
        }

        .nv-related-posts {
            --relatedcolumns: 1;
            --relatedContentAlign: left;
        }

        .layout-grid .nv-post-thumbnail-wrap {
            margin-right: -16px;
            margin-left: -16px;
        }

        .nv-index-posts {
            --padding: 0 16px 16px 16px;;
            --gridspacing: 30px;
            --borderradius: 0px;
            --cardboxshadow: 0 0 0px 0 rgba(0, 0, 0, 0.1);
            --cardbgcolor: var(--nv-site-bg);
            --cardcolor: var(--nv-text-color);
        }

        .scroll-to-top {
            --color: var(--nv-text-dark-bg);
            --padding: 8px 10px;
            --borderradius: 3px;
            --bgcolor: var(--nv-primary-accent);
            --hovercolor: var(--nv-text-dark-bg);
            --hoverbgcolor: var(--nv-primary-accent);
            --size: 16px;
        }

        @media (min-width: 576px) {
            :root {
                --container: 992px;
                --postwidth: 50%;
                --btnpadding: 13px 15px;
                --primarybtnpadding: 13px 15px;
                --secondarybtnpadding: calc(13px - 3px) calc(15px - 3px);
                --bodyfontsize: 16px;
                --bodylineheight: 1.6em;
                --bodyletterspacing: 0px;
                --h1fontsize: 38px;
                --h1lineheight: 1.2em;
                --h1letterspacing: 0px;
                --h2fontsize: 30px;
                --h2lineheight: 1.2em;
                --h2letterspacing: 0px;
                --h3fontsize: 26px;
                --h3lineheight: 1.4em;
                --h3letterspacing: 0px;
                --h4fontsize: 22px;
                --h4lineheight: 1.5em;
                --h4letterspacing: 0px;
                --h5fontsize: 18px;
                --h5lineheight: 1.6em;
                --h5letterspacing: 0px;
                --h6fontsize: 14px;
                --h6lineheight: 1.6em;
                --h6letterspacing: 0px;
            }

            .single-post-container .alignfull > [class*="__inner-container"], .single-post-container .alignwide > [class*="__inner-container"] {
                max-width: 962px
            }

            .nv-meta-list {
                --avatarsize: 20px;
            }

            .single .nv-meta-list {
                --avatarsize: 20px;
            }

            .single h1.entry-title {
                --fontsize: 40px;
            }

            .nv-post-cover {
                --height: 160px;
                --padding: 32px 24px;
                --justify: center;
                --textalign: center;
                --valign: center;
            }

            .nv-post-cover .nv-title-meta-wrap, .nv-page-title-wrap, .entry-header {
                --textalign: center;
            }

            .nv-is-boxed.nv-title-meta-wrap {
                --padding: 60px 30px;
            }

            .nv-is-boxed.nv-comments-wrap {
                --padding: 30px;
            }

            .nv-is-boxed.comment-respond {
                --padding: 30px;
            }

            .single:not(.single-product), .page {
                --c-vspace: 0 0 0 0;;
            }

            .header-main {
                --rowbwidth: 0px;
            }

            .header-menu-sidebar-bg {
                --justify: flex-start;
                --textalign: left;
                --flexg: 1;
                --wrapdropdownwidth: auto;
            }

            .header-menu-sidebar {
                width: 360px;
            }

            .builder-item--logo {
                --maxwidth: 120px;
                --fs: 24px;
                --padding: 10px 0;
                --margin: 0;
                --textalign: left;
                --justify: flex-start;
            }

            .builder-item--nav-icon {
                --label-margin: 0 5px 0 0;;
                --padding: 10px 15px;
                --margin: 0;
            }

            .builder-item--primary-menu {
                --spacing: 20px;
                --height: 25px;
                --smiconsize: 7px;
                --padding: 0;
                --margin: 0;
                --fontsize: 1em;
                --lineheight: 1.6em;
                --letterspacing: 0px;
                --iconsize: 1em;
            }

            .builder-item--primary-menu .sub-menu {
                --justify: left;
                --spacebetween: 0px;
                --bwidth: 0;
                --bradius: 0px;
            }

            .builder-item--button_base {
                --padding: 8px 12px;
                --margin: 0;
            }

            .builder-item--social_icons {
                --spacing: 10px;
                --borderradius: 5px;
                --iconpadding: 5px;
                --icon-size: 18px;
                --padding: 0;
                --margin: 0;
            }

            .footer-main {
                --rowbwidth: 0px;
            }

            .footer-bottom {
                --rowbwidth: 0px;
            }

            .builder-item--footer-one-widgets {
                --padding: 40px 0 0 0;;
                --margin: 0;
                --textalign: left;
                --justify: flex-start;
            }

            .builder-item--footer-two-widgets {
                --padding: 20px 0 0 0;;
                --margin: 0;
                --textalign: left;
                --justify: flex-start;
            }

            .builder-item--footer-three-widgets {
                --padding: 20px 0 40px 0;;
                --margin: 0;
                --textalign: left;
                --justify: flex-start;
            }

            .builder-item--footer-menu {
                --spacing: 20px;
                --height: 25px;
                --padding: 0 0 10px 0;;
                --margin: 0;
                --fontsize: 1em;
                --lineheight: 1.6em;
                --letterspacing: 0px;
                --iconsize: 1em;
                --textalign: left;
                --justify: flex-start;
            }

            .builder-item--footer_copyright {
                --padding: 10px 0 0 0;;
                --margin: 0;
                --fontsize: 1em;
                --lineheight: 1.6em;
                --letterspacing: 0px;
                --iconsize: 1em;
                --textalign: left;
                --justify: flex-start;
            }

            .nv-related-posts {
                --relatedcolumns: 1;
                --relatedContentAlign: left;
            }

            .layout-grid .nv-post-thumbnail-wrap {
                margin-right: -24px;
                margin-left: -24px;
            }

            .nv-index-posts {
                --padding: 0 24px 24px 24px;;
                --gridspacing: 30px;
            }

            .scroll-to-top {
                --padding: 8px 10px;
                --size: 16px;
            }
        }

        @media (min-width: 960px) {
            :root {
                --container: 1170px;
                --postwidth: 50%;
                --btnpadding: 12px 24px;
                --primarybtnpadding: 12px 24px;
                --secondarybtnpadding: calc(12px - 3px) calc(24px - 3px);
                --bodyfontsize: 18px;
                --bodylineheight: 1.7em;
                --bodyletterspacing: 0px;
                --h1fontsize: 56px;
                --h1lineheight: 1.1em;
                --h1letterspacing: 0px;
                --h2fontsize: 44px;
                --h2lineheight: 1.2em;
                --h2letterspacing: 0px;
                --h3fontsize: 32px;
                --h3lineheight: 1.4em;
                --h3letterspacing: 0px;
                --h4fontsize: 24px;
                --h4lineheight: 1.5em;
                --h4letterspacing: 0px;
                --h5fontsize: 18px;
                --h5lineheight: 1.6em;
                --h5letterspacing: 0px;
                --h6fontsize: 14px;
                --h6lineheight: 1.6em;
                --h6letterspacing: 0px;
            }

            body:not(.single):not(.archive):not(.blog):not(.search):not(.error404) .neve-main > .container .col, body.post-type-archive-course .neve-main > .container .col, body.post-type-archive-llms_membership .neve-main > .container .col {
                max-width: 100%;
            }

            body:not(.single):not(.archive):not(.blog):not(.search):not(.error404) .nv-sidebar-wrap, body.post-type-archive-course .nv-sidebar-wrap, body.post-type-archive-llms_membership .nv-sidebar-wrap {
                max-width: 0%;
            }

            .neve-main > .archive-container .nv-index-posts.col {
                max-width: 100%;
            }

            .neve-main > .archive-container .nv-sidebar-wrap {
                max-width: 0%;
            }

            .neve-main > .single-post-container .nv-single-post-wrap.col {
                max-width: 70%;
            }

            .single-post-container .alignfull > [class*="__inner-container"], .single-post-container .alignwide > [class*="__inner-container"] {
                max-width: 789px
            }

            .container-fluid.single-post-container .alignfull > [class*="__inner-container"], .container-fluid.single-post-container .alignwide > [class*="__inner-container"] {
                max-width: calc(70% + 15px)
            }

            .neve-main > .single-post-container .nv-sidebar-wrap {
                max-width: 30%;
            }

            .nv-meta-list {
                --avatarsize: 20px;
            }

            .single .nv-meta-list {
                --avatarsize: 20px;
            }

            .blog .nv-meta-list li, .archive .nv-meta-list li {
                --fontsize: 14px;
                --letterspacing: 2px;
            }

            .single h1.entry-title {
                --fontsize: 56px;
                --lineheight: 1.35em;
            }

            .single .nv-meta-list li {
                --lineheight: 1em;
            }

            .nv-post-cover {
                --height: 200px;
                --padding: 32px 24px;
                --justify: center;
                --textalign: center;
                --valign: center;
            }

            .nv-post-cover .nv-title-meta-wrap, .nv-page-title-wrap, .entry-header {
                --textalign: center;
            }

            .nv-is-boxed.nv-title-meta-wrap {
                --padding: 60px 40px;
            }

            .nv-is-boxed.nv-comments-wrap {
                --padding: 40px;
            }

            .nv-is-boxed.comment-respond {
                --padding: 40px;
            }

            .single:not(.single-product), .page {
                --c-vspace: 0px 0 0 0;;
            }

            .header-main {
                --rowbwidth: 1px;
            }

            .header-menu-sidebar-bg {
                --justify: flex-start;
                --textalign: left;
                --flexg: 1;
                --wrapdropdownwidth: auto;
            }

            .header-menu-sidebar {
                width: 360px;
            }

            .builder-item--logo {
                --maxwidth: 120px;
                --fs: 24px;
                --padding: 10px 0;
                --margin: 0;
                --textalign: left;
                --justify: flex-start;
            }

            .builder-item--nav-icon {
                --label-margin: 0 5px 0 0;;
                --padding: 10px 15px;
                --margin: 0;
            }

            .builder-item--primary-menu {
                --spacing: 20px;
                --height: 25px;
                --smiconsize: 7px;
                --padding: 0;
                --margin: 0;
                --fontsize: 1em;
                --lineheight: 1.6em;
                --letterspacing: 0px;
                --iconsize: 1em;
            }

            .builder-item--primary-menu .sub-menu {
                --justify: left;
                --spacebetween: 8px;
                --bwidth: 1px;
                --bradius: 0px;
            }

            .builder-item--button_base {
                --padding: 8px 24px 8px 23px;;
                --margin: 0;
            }

            .builder-item--social_icons {
                --spacing: 0px;
                --borderradius: 5px;
                --iconpadding: 10px;
                --icon-size: 25px;
                --padding: 0;
                --margin: 0;
            }

            .footer-main {
                --rowbwidth: 1px;
            }

            .footer-bottom {
                --rowbwidth: 1px;
            }

            .builder-item--footer-one-widgets {
                --padding: 40px 24px;
                --margin: 0;
                --textalign: left;
                --justify: flex-start;
            }

            .builder-item--footer-two-widgets {
                --padding: 40px 24px;
                --margin: 0;
                --textalign: left;
                --justify: flex-start;
            }

            .builder-item--footer-three-widgets {
                --padding: 40px 24px;
                --margin: 0;
                --textalign: left;
                --justify: flex-start;
            }

            .builder-item--footer-menu {
                --spacing: 20px;
                --height: 25px;
                --padding: 0 24px;
                --margin: 0;
                --fontsize: 14px;
                --lineheight: 1em;
                --letterspacing: 2px;
                --iconsize: 14px;
                --textalign: right;
                --justify: flex-end;
            }

            .builder-item--footer_copyright {
                --padding: 0;
                --margin: 0 24px;
                --fontsize: 14px;
                --lineheight: 1em;
                --letterspacing: 2px;
                --iconsize: 14px;
                --textalign: left;
                --justify: flex-start;
            }

            .nv-related-posts {
                --relatedcolumns: 2;
                --relatedContentAlign: left;
            }

            .layout-grid .nv-post-thumbnail-wrap {
                margin-right: -32px;
                margin-left: -32px;
            }

            .nv-index-posts {
                --padding: 0 32px 32px 32px;;
                --gridspacing: 32px;
            }

            .scroll-to-top {
                --padding: 8px 10px;
                --size: 16px;
            }
        }

        .scroll-to-top {
            right: 20px;
            border: none;
            position: fixed;
            bottom: 30px;
            display: none;
            opacity: 0;
            visibility: hidden;
            transition: opacity 0.3s ease-in-out, visibility 0.3s ease-in-out;
            align-items: center;
            justify-content: center;
            z-index: 999;
        }

        @supports (-webkit-overflow-scrolling: touch) {
            .scroll-to-top {
                bottom: 74px;
            }
        }

        .scroll-to-top.image {
            background-position: center;
        }

        .scroll-to-top .scroll-to-top-image {
            width: 100%;
            height: 100%;
        }

        .scroll-to-top .scroll-to-top-label {
            margin: 0;
            padding: 5px;
        }

        .scroll-to-top:hover {
            text-decoration: none;
        }

        .scroll-to-top.scroll-to-top-left {
            left: 20px;
            right: unset;
        }

        .scroll-to-top.scroll-show-mobile {
            display: flex;
        }

        @media (min-width: 960px) {
            .scroll-to-top {
                display: flex;
            }
        }

        .scroll-to-top {
            color: var(--color);
            padding: var(--padding);
            border-radius: var(--borderradius);
            background: var(--bgcolor);
        }

        .scroll-to-top:hover, .scroll-to-top:focus {
            color: var(--hovercolor);
            background: var(--hoverbgcolor);
        }

        .scroll-to-top-icon, .scroll-to-top.image .scroll-to-top-image {
            width: var(--size);
            height: var(--size);
        }

        .scroll-to-top-image {
            background-image: var(--bgimage);
            background-size: cover;
        }

        :root {
            --nv-primary-accent: #e76116;
            --nv-secondary-accent: #2f3f8e;
            --nv-site-bg: #f3e4dc;
            --nv-light-bg: #ddd6ce;
            --nv-dark-bg: #000000;
            --nv-text-color: #272626;
            --nv-text-dark-bg: #ffffff;
            --nv-c-1: #9463ae;
            --nv-c-2: #be574b;
            --nv-fallback-ff: Arial, Helvetica, sans-serif;
        }
    </style>
    <?
	do_action( 'neve_head_end_before' );
	?>
</head>

<body  <?php body_class(); ?> <?php neve_body_attrs(); ?> >
<?php
/**
 * Executes actions after the body tag is opened.
 *
 * @since 2.11
 */
do_action( 'neve_body_start_after' );
?>
<?php wp_body_open(); ?>
<div class="wrapper">
	<?php
	/**
	 * Executes actions before the header tag is opened.
	 *
	 * @since 2.7.2
	 */
	do_action( 'neve_before_header_wrapper_hook' );
	?>

	<header class="<?php echo esc_attr( $header_classes ); ?>" <?php echo ( neve_is_amp() ) ? 'next-page-hide' : ''; ?> >
		<a class="neve-skip-link show-on-focus" href="#content" >
			<?php echo __( 'Skip to content', 'neve' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		</a>
		<?php

		/**
		 * Executes actions before the header ( navigation ) area.
		 *
		 * @since 1.0.0
		 */
		do_action( 'neve_before_header_hook' );

		if ( apply_filters( 'neve_filter_toggle_content_parts', true, 'header' ) === true ) {
			do_action( 'neve_do_header' );
		}

		/**
		 * Executes actions after the header ( navigation ) area.
		 *
		 * @since 1.0.0
		 */
		do_action( 'neve_after_header_hook' );
		?>
	</header>

	<?php
	/**
	 * Executes actions after the header tag is closed.
	 *
	 * @since 2.7.2
	 */
	do_action( 'neve_after_header_wrapper_hook' );
	?>


	<?php
	/**
	 * Executes actions before main tag is opened.
	 *
	 * @since 1.0.4
	 */
	do_action( 'neve_before_primary' );
	?>

	<main id="content" class="neve-main">

<?php
/**
 * Executes actions after main tag is opened.
 *
 * @since 1.0.4
 */
do_action( 'neve_after_primary_start' );

