<?php
/**
 * Sparks Functions to Wrap WP/WooCommerce Core Functions.
 *
 * @package Codeinwp\Sparks\Utilities
 */

if ( ! function_exists( 'sparks_enqueue_style' ) ) {
	/**
	 * Enqueue style
	 *
	 * @param  string           $handle Name of the style.
	 * @param  string           $src [optional] URL or path.
	 * @param  string[]         $deps [optional] Needed dependencies.
	 * @param  string|bool|null $ver [optional] Version number.
	 * @return void
	 */
	function sparks_enqueue_style( $handle, $src = '', array $deps = [], $ver = SPARKS_WC_VERSION ) {
		if ( apply_filters( 'sparks_needs_enqueue_style', true, $handle, $src ) ) {
			wp_enqueue_style( $handle, $src, $deps, $ver );
		}
	}
}

if ( ! function_exists( 'sparks_enqueue_script' ) ) {
	/**
	 * Enqueue Script
	 *
	 * @param  string           $handle Name of the script.
	 * @param  string           $src [Optional] URL or path.
	 * @param  string[]         $deps [Optional] Dependencies.
	 * @param  string|bool|null $ver [optional] Version number.
	 * @param  bool             $in_footer [Optional] Load before the </body> tag or not.
	 * @return void
	 */
	function sparks_enqueue_script( $handle, $src = '', array $deps = [], $ver = SPARKS_WC_VERSION, $in_footer = false ) {
		if ( apply_filters( 'sparks_needs_enqueue_script', true, $handle, $src ) ) {
			wp_enqueue_script( $handle, $src, $deps, $ver, $in_footer );
		}
	}
}
