<?php
/**
 * Template of the Product Edit -> Product Data -> Product Tabs section.
 *
 * @package Codeinwp\Sparks\Modules\Tab_Manager\Templates
 *
 * @var string $override_tab_layout
 * @var string $template_output
 * @var array<int, array{'id': int, 'title': string, 'type': string, 'editUrl': string, 'slug': string}> $global_tabs_data
 * @var string $general_tab_template_output
 * @var string|false $json_tabs_data
 * @var array $esc_allowed_tags Allowed escaping tags
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<style type='text/css'>
	#sp-product-tabs .toolbar { display: flex; justify-content: end; }
	.sp-tab-handle {
		margin-top: .25em;
		cursor: move;
		float: right;
		margin-right: .5em;
		vertical-align: middle;
	}
	.sp-tab-handle:before {
		content: "\f333";
		font-family: Dashicons;
		text-align: center;
		line-height: 28px;
		color: #999;
	}
	.sp-tab-toggle {
		margin-top: .25em;
		width: 27px;
		float: right;
	}
	.sp-tab-toggle:before {
		content: "\f140";
		cursor: pointer;
		display: inline-block;
		font: 400 20px/1 Dashicons;
		line-height: .5!important;
		padding: 8px 10px;
		position: relative;
		right: 12px;
		top: 0;
	}
	#sp-product-tabs .wc-metabox table td input[type="button"] {
		width: auto;
		min-width: auto;
	}
	.sp-tab-block {
		background-color: white;
		height: 100%;
		left: 0;
		opacity: 0.6;
		position: absolute;
		top: 0;
		width: 100%;
	}
</style>

<div id="sp-product-tabs" class="panel wc-metaboxes-wrapper">
	<p class="toolbar">
		<label for="_override_tab_layout">
			<?php esc_html_e( 'Override default tab layout:', 'sparks-for-woocommerce' ); ?>
		</label>
		<input type="checkbox" name="neve_override_tab_layout" id="sparks_override_tab_layout" <?php checked( $override_tab_layout, 'on' ); ?> />
	</p>

	<div style="position:relative;">
		<div class="wc-metaboxes">
			<?php echo wp_kses( $template_output, $esc_allowed_tags ); ?>
		</div>
		<p class="toolbar">
			<button type="button" class="button button-primary sp-add-tab">
				<?php esc_html_e( 'Add', 'sparks-for-woocommerce' ); ?>
			</button>
			<select name="sp-insert-new-tab" class="sp-insert-new-tab">
				<option value="">
					<?php esc_html_e( 'Custom Tab', 'sparks-for-woocommerce' ); ?>
				</option>
				<?php
				foreach ( $global_tabs_data as $tab_data ) {
					echo '<option value="' . esc_attr( $tab_data['slug'] ) . '">' . esc_html( $tab_data['title'] ) . '</option>';
				}
				?>
			</select>
		</p>

		<div class="sp-tab-block"
		<?php
		if ( 'on' === $override_tab_layout ) {
			echo 'style="display:none"'; }
		?>
		></div>
		<div class="sp-tab-template" style="display: none;">
			<?php echo wp_kses( $general_tab_template_output, $esc_allowed_tags ); ?>
		</div>
		<?php

		if ( false !== $json_tabs_data ) {
			echo '<input class="sparks_tab_data_collector" name="neve_tab_data_collector" type="hidden" value=\'' . esc_attr( $json_tabs_data ) . '\'/>';
		}
		?>
	</div>
</div>
