# RSS Aggregator by Feedzy – Feed to Post, Autoblogging, News & YouTube Video Feeds Aggregator #
**Contributors:** [themeisle](https://profiles.wordpress.org/themeisle), [codeinwp](https://profiles.wordpress.org/codeinwp), [hardeepasrani](https://profiles.wordpress.org/hardeepasrani), [rozroz](https://profiles.wordpress.org/rozroz)  
**Tags:** rss aggregator, news aggregator, autoblogging, feed to post, rss import, autoblog, rss feed  
**Requires at least:** 3.7  
**Requires PHP:** 5.3  
**Tested up to:** 5.6  
**Stable tag:** trunk  
**License:** GPLv2 or later  
**License URI:** http://www.gnu.org/licenses/gpl-2.0.html  

The most powerful WordPress RSS aggregator, helping you curate content, autoblog, import and display unlimited RSS feeds within a few minutes.

## Description ##

## FEEDZY - The Powerful RSS Aggregator, Content Aggregator, and RSS import Plugin for Autoblogging ##

The Ultimate WordPress RSS aggregator, helping you Curate content, Autoblog, Import RSS, News aggregator, YouTube video feeds aggregator and display unlimited RSS feeds within a few minutes.

## 🔗 HELPFUL LINKS: ##

* Want to see Feedzy in action before installing? [VIEW FEEDZY DEMO](https://demo.themeisle.com/feedzy-rss-feeds/?utm_source=wpadmin&utm_medium=readme&utm_campaign=feeedzy)
* Need any help with setup? [CHECK DOCUMENTATION](https://docs.themeisle.com/category/712-feedzy)
* Don’t like reading? [CHECK YOUTUBE TUTORIALS](https://www.youtube.com/channel/UCAQcBsP3h6p5yXgFap4LEGA/search?query=feedzy)
* Interested in Feedzy Pro? [KNOW MORE ABOUT FEEDZY PRO](https://themeisle.com/plugins/feedzy-rss-feeds/upgrade/?utm_source=wpadmin&utm_medium=readme&utm_campaign=feeedzy)

With FEEDZY RSS Aggregator, you can sit back, let your site autoblog and always stay fresh with new content, which in return helps improve content marketing, boost your SEO, increase audience engagement, and probably earn more money.

FEEDZY RSS Aggregator helps you aggregate unlimited RSS feeds and automatically publish them on your site within a few minutes.

## 🤔 WHAT YOU CAN DO WITH FEEDZY RSS AGGREGATOR: ##

* **[Feed to post](https://docs.themeisle.com/article/742-how-to-import-posts-from-feeds-in-feedzy)** (our most loved feature 💕): automatically convert RSS feed items to Wordpress pages, posts, and custom post type.
* **Automatically import** and aggregate unlimited RSS feeds from unlimited sources
* **Bulk import and organize** multiple feed sources of similar topics into Categories. See how our user, **Barry Seward**, loves this feature [here](https://wordpress.org/support/topic/works-great-6051/)
* **Easily display RSS feeds** using shortcodes, Gutenberg blocks, or widgets in your third-party page builders like Elementor
* **Import images** with your RSS feeds or use your own image/logo for feeds without image. We know visuals are important and do not want your site to have a boring list of text and links.
* **Control the number of items** 🔢 you want to display for a feed source. Just want to display 1 article or 20 articles in a block? You’ve got it with one click.
* Worried if the imported feed articles’ titles are too long and might not look nice on your site? Change them with the **Title Character Limit** function.
* Choose your own **caching** time and how often you want to pull RSS feeds to ensure the **best performance** for your site.
* Create a **sidebar** of your imported feed items.
* **Control which meta** 🎛️ fields you want to display, such as author, date and time of the RSS feed.
* **Responsive** content 📱 across platforms.

## CHECK OUT A QUICK OVERVIEW OF FEEDZY ##
https://youtu.be/YcMn_yicgGg

## ✨ YOU SHOULD USE FEEDZY RSS AGGREGATOR IF: ##

* [You own a news site](https://themeisle.com/blog/wordpress-news-aggregator-website/); you want a WP news aggregator to make sure your site always updated with the latest news
* You own a blog; you need a [WP content aggregator to autoblog](https://themeisle.com/blog/create-an-autoblogging-site-wordpress/) and keep your audience engaged with fresh content
* You want to improve your SEO rankings. See how the SEO expert, MOZ, talked about 10 reasons “[How Fresh Content May Influence Google Rankings”](https://moz.com/blog/google-fresh-factor-new)“
* You develop a site for your client and just want to quickly demo a news feed of frequently  updated content
* You build a company website and want a news/blog page to enhance the company’s reputation and SEO. Focus on your business and leave the content marketing work to FEEDZY RSS Aggregator.
* You run an affiliate business or want to earn extra from RSS affiliate marketing feeds
* You need a simple but comprehensive solution to curate anything in your niche, such as property listing for a real estate website, product listing for an affiliated e-commerce site, etc.
* Your goal is to generate increased revenue, thanks to the advantages outlined above.

It doesn't matter which industry or topic your site focuses on. With over 50,000+ users, FEEDZY RSS Aggregator has been used to curate content from a diverse range, including finance, technology, food, home furniture, e-commerce products, religion, sports, and more. 

**Note:** To learn more about how to use curated content to boost your SEO in a proper and effective way, read more [here](http://www.curata.com/blog/content-curation-seo-dos-and-donts/).

## 🤝 MORE POWER WITH FEEDZY RSS AGGREGATOR’S PREMIUM FEATURES ##

If you love FEEDZY RSS Aggregator, why not bring your site to the next level with more powerful tools to boost your SEO and keep your audience on your site for longer.

* **[Keyword filter](https://docs.themeisle.com/article/942-in-feedzy-how-do-i#specific-keywords)**: you can choose to import feed to post and display content if they include or exclude certain keywords.

**USE CASE:** 🔍 Mark, a content curator, maximizes efficiency with Keyword Filter. He effortlessly refines his RSS feed imports by specifying keywords like "AI" and "tech trends." This automatic sorting saves Mark hours of manual review, allowing him to focus on crafting engaging content and boosting his blog's SEO impact. 

* **Map the imported feed elements to your post elements**: totally control and customize how your feed to post, such as using the feed’s image or your image as the featured image, importing only the feed’s content or both the content and image into the post content, creating post drafts first to review or publishing right away, and so many more.
* **[Full-text RSS feeds import (with image)](https://docs.themeisle.com/article/742-how-to-import-posts-from-feeds-in-feedzy)** (with image): by extracting the entire HTML from each feed item, you can import full-text content to post, not just the feed excerpt.
* **Paraphrasing content before import**: Rewrite your content before RSS import with the built-in feature.
* **Automatically translate the content on import**: Choose to translate the feed into various languages before import.
* **[Multiple feed templates](https://demo.themeisle.com/feedzy-rss-feeds/)**: choose the best template for each feed, such as standard grid layout, blog layout, online shop layout, or audio playback (soundcloud) playout.
* **[WordAI and SpinnerChief integration](https://docs.themeisle.com/article/746-how-to-use-wordai-to-rephrase-rss-content-in-feedzy)** to avoid duplicated content.
* **[Parse and display pricings](https://docs.themeisle.com/article/923-how-price-is-displayed-from-the-feed)** for online shop and product feeds.
* **[Add affiliate links and referral parameters](https://docs.themeisle.com/article/715-feedzy-how-to-add-affiliate-referrals-to-feed-urls)** for your affiliate business.

**USE CASE:** Mike, an affiliate marketing expert, is all about maximizing profits. By seamlessly incorporating personalized referral links into his content using the "Add Affiliate Links and Referral Parameters" feature, he simplifies tracking and improves campaign efficiency. The result? Heightened conversions, enhanced earnings, and a stronger affiliate game.

Unlock all these premium features with [Feedzy PRO!](https://themeisle.com/plugins/feedzy-rss-feeds/upgrade/?utm_source=wpadmin&utm_medium=readme&utm_campaign=feeedzy)

* Still sceptical? Ask your pre-sales questions [here](https://themeisle.com/contact/) and we will get back shortly, or purchase with peace of mind and try it out yourself. We offer **30-day-no-questions-asked money-back guarantee.**

## WE’RE HERE FOR YOU, AND WE TAKE ALL FEEDBACK SERIOUSLY ##

* 📚 [Knowledge Base](https://docs.themeisle.com/category/712-feedzy): we’ve created a complete documentation library and we’re still constantly updating with new tutorials.
* 📽️ [Youtube tutorials](https://www.youtube.com/channel/UCAQcBsP3h6p5yXgFap4LEGA/search?query=feedzy): don’t like reading? We’ve created some YouTube tutorials to help you get started with the FEEDZY RSS Aggregator plugin step by step.
* 🦸 [Support forum](https://wordpress.org/support/plugin/feedzy-rss-feeds/): we offer support to free version user here and try to reply within one business day.
* 🌟 [Premium support](https://themeisle.com/contact/): We offer priority support for Developer license customers and live chat support for Agency license customers.

If you have any feedback or feature suggestions for the FEEDZY RSS Aggregator, don’t hesitate to tell us. We read all feedback and ideas.

## You’re in good hands ##

FEEDZY RSS Aggregator is one of many great products by [ThemeIsle](https://themeisle.com/). Join over 30,000 FEEDZY RSS Aggregator users and half of a million ThemeIsle users from all over the world.

See what real users talk about us:

* FEEDZY RSS Aggregator in [WordPress Daily with Tom Mullins](https://www.youtube.com/watch?v=J7q_g0N7Efc)
* [Lester Diaz showed how to make $200 per day](https://www.youtube.com/watch?v=WC2Tc830yMs) using FEEDZY RSS Aggregator
* [“Simple and beautiful”](https://wordpress.org/support/topic/simple-and-beautiful-58/) and 5 stars from a power user using FEEDZY RSS Aggregator for blogspot
* [“Excellent plugin”](https://wordpress.org/support/topic/excellent-plugin-4867/) and 5 stars from a power user using FEEDZY RSS Aggregator for Mailchimp mailing list
* [“Robust tool but also works great for simple needs”](https://wordpress.org/support/topic/robust-tool-but-also-works-great-for-simple-needs/) and 5 stars from a power user using FEEDZY RSS Aggregator to display recent posts with excerpts

## Technical note ##

FEEDZY RSS Aggregator supports any additional library and takes up minimal space in your cache/CSS to ensure high performance. This ensures compatibility with any hosting provider that supports WordPress, but if for any reason it doesn’t work for yours feel free to [create a new support topic](https://wordpress.org/support/plugin/feedzy-rss-feeds/#new-post).

 = Shortcode Parameters =


	* feeds
	* max
	* feed_title
	* target
	* title
	* meta
	* summary
	* summarylength
	* thumb
	* default
	* refresh
	* size
	* keywords_title



**Plugin is now using the TinyMCE API to improve UI and makes it easy to insert shortcodes!**


### Basic example ###

`[feedzy-rss feeds="http://themeisle.com/feed"]`


### Advanced example ###

`[feedzy-rss feeds="http://themeisle.com/feed" max="2" feed_title="yes" target="_blank"  refresh="12_hours" title="50" meta="author, date, time, tz=local" summary="yes" summarylength="300" thumb="yes" size="100" default="http://your-site/default-image.jpg" keywords_title="WordPress"]`


### Available Hooks ###


	* feedzy_feed_items
	* feedzy_item_keyword
	* feedzy_item_attributes
	* feedzy_thumb_output
	* feedzy_title_output
	* feedzy_meta_args
	* feedzy_meta_output
	* feedzy_summary_input
	* feedzy_summary_output
	* feedzy_global_output
	* feedzy_thumb_sizes
	* feedzy_feed_blacklist_images
	* feedzy_default_image
	* feedzy_default_error
	* feedzy_item_filter
	* feedzy_author_url
	* feedzy_item_url_filter
	* feedzy_feed_timestamp
	* shortcode_atts_feedzy_default

## BECOME A CONTRIBUTOR ##
FEEDZY RSS Aggregator plugin is an open-source project, and we welcome contributors to be part of our vibrant community! Help us improve the plugin and make it even better - [GITHUB LINK](https://github.com/Codeinwp/feedzy-rss-feeds/)

This plugin is maintained and supported by Themeisle, check out some of the other <a href="http://themeisle.com/wordpress-plugins/" rel="nofollow">WordPress plugins</a> and <a href="http://themeisle.com/wordpress-themes/free/" rel="nofollow">free themes</a> we've developed.

## Installation ##

1. Upload and activate the plugin (or install it through the WP admin console)
2. Insert shortcode ! ;-)

## Frequently Asked Questions ##
















### Is it responsive friendly? ###

Yes it is.

### My feed is not displayed and the following message appears "Sorry, this feed is currently unavailable or does not exists anymore." ###

You have to check first if your feed is valid. Please test it here: https://validator.w3.org/feed/

### Where do i find the plugin documentation ###
[http://docs.themeisle.com/article/658-feedzy-rss-feeds](http://docs.themeisle.com/article/658-feedzy-rss-feeds)

### How to fix images that are not showing in the feed ###
[http://docs.themeisle.com/article/666-how-to-fix-images-that-are-not-showing-in-the-feed](http://docs.themeisle.com/article/666-how-to-fix-images-that-are-not-showing-in-the-feed)

### How to change cache lifetime for a specific feed ###
[http://docs.themeisle.com/article/547-how-to-change-cache-lifetime-for-a-specific-feed](http://docs.themeisle.com/article/547-how-to-change-cache-lifetime-for-a-specific-feed)

### How to change thumbs size and aspect ratio ###
[http://docs.themeisle.com/article/551-how-to-change-thumbs-size-and-aspect-ratio](http://docs.themeisle.com/article/551-how-to-change-thumbs-size-and-aspect-ratio)

### What hooks and filters are available in Feedzy ###
[http://docs.themeisle.com/article/540-what-hooks-and-filters-are-available-in-feedzy](http://docs.themeisle.com/article/540-what-hooks-and-filters-are-available-in-feedzy)

### How to change the blacklist image name ###
[http://docs.themeisle.com/article/552-how-to-change-the-blacklist-image-name](http://docs.themeisle.com/article/552-how-to-change-the-blacklist-image-name)

### How to decode item title ###
[http://docs.themeisle.com/article/548-how-to-decode-item-title-with](http://docs.themeisle.com/article/548-how-to-decode-item-title-with)

### How to remove featured image from blog feed ###
[http://docs.themeisle.com/article/554-how-to-remove-featured-image-from-blog-feed](http://docs.themeisle.com/article/554-how-to-remove-featured-image-from-blog-feed)

### How to keep html in feed items content ###
[http://docs.themeisle.com/article/542-how-to-keep-html-in-feed-items-content](http://docs.themeisle.com/article/542-how-to-keep-html-in-feed-items-content)

### How to remove plugin css ###
[http://docs.themeisle.com/article/545-how-to-remove-plugin-css](http://docs.themeisle.com/article/545-how-to-remove-plugin-css)

### How to remove links ###
[https://docs.themeisle.com/article/1049-how-to-remove-links-in-feedzy](https://docs.themeisle.com/article/1049-how-to-remove-links-in-feedzy)

### How to add a read more link ###
[http://docs.themeisle.com/article/544-how-to-add-a-read-more-link](http://docs.themeisle.com/article/544-how-to-add-a-read-more-link)

### How to remove time from publication date ###
[http://docs.themeisle.com/article/553-how-to-remove-time-from-publication-date](http://docs.themeisle.com/article/553-how-to-remove-time-from-publication-date)

### How to handle publication date and author content ###
[http://docs.themeisle.com/article/549-how-to-handle-time-and-date-content](http://docs.themeisle.com/article/549-how-to-handle-time-and-date-content)

### How to use your own inline css ###
[http://docs.themeisle.com/article/546-how-to-use-your-own-inline-css](http://docs.themeisle.com/article/546-how-to-use-your-own-inline-css)

### How to remove the end hellip ###
[http://docs.themeisle.com/article/543-how-to-remove-the-end-hellip](http://docs.themeisle.com/article/543-how-to-remove-the-end-hellip)

### How to display items in a random order ###
[http://docs.themeisle.com/article/550-how-to-display-items-in-a-random-order](http://docs.themeisle.com/article/550-how-to-display-items-in-a-random-order)

### How to sort items alphabetically by their title ###
[http://docs.themeisle.com/article/633-how-to-sort-feed-items-by-title](http://docs.themeisle.com/article/633-how-to-sort-feed-items-by-title)

### How to display RSS feed time and date in local time ###
[http://docs.themeisle.com/article/567-how-to-display-rss-feed-time-and-date-in-local-time](http://docs.themeisle.com/article/567-how-to-display-rss-feed-time-and-date-in-local-time)

### How to change author url ###
[http://docs.themeisle.com/article/636-how-to-change-author-url](http://docs.themeisle.com/article/636-how-to-change-author-url)

### How remove feed items duplicates by url ###
[http://docs.themeisle.com/article/638-how-to-eliminate-duplicate-feed-item](http://docs.themeisle.com/article/638-how-to-eliminate-duplicate-feed-item)

### How to use feedzy categories ###
[http://docs.themeisle.com/article/640-how-to-use-feedzy-categories](http://docs.themeisle.com/article/640-how-to-use-feedzy-categories)

### How to add a read more link to Feedzy ###
 [http://docs.themeisle.com/article/544-how-to-add-a-read-more-link-to-feedzy](http://docs.themeisle.com/article/544-how-to-add-a-read-more-link-to-feedzy)

 = How to move Feedzy templates to your theme =
 [http://docs.themeisle.com/article/573-how-to-move-feedzy-templates-to-your-theme](http://docs.themeisle.com/article/573-how-to-move-feedzy-templates-to-your-theme)

 = How to eliminate duplicate feed items. =
 [http://docs.themeisle.com/article/638-how-to-eliminate-duplicate-feed-items](http://docs.themeisle.com/article/638-how-to-eliminate-duplicate-feed-items)

 = How to check whether the RSS feed is valid or not in Feedzy =
 [http://docs.themeisle.com/article/716-feedzy-how-to-check-whether-the-rss-feed-is-valid-or-not](http://docs.themeisle.com/article/716-feedzy-how-to-check-whether-the-rss-feed-is-valid-or-not)

 = How to change user agent in Feedzy =
 [http://docs.themeisle.com/article/713-how-to-change-user-agent-in-feedzy](http://docs.themeisle.com/article/713-how-to-change-user-agent-in-feedzy)

 = How to use proxy settings in Feedzy =
 [http://docs.themeisle.com/article/714-how-to-use-proxy-settings-in-feezy](http://docs.themeisle.com/article/714-how-to-use-proxy-settings-in-feezy)

 = How to import posts from feeds in Feedzy =
 [http://docs.themeisle.com/article/742-how-to-import-posts-from-feeds-in-feedzy](http://docs.themeisle.com/article/742-how-to-import-posts-from-feeds-in-feedzy)

 = Where can I find the import posts options in Feedzy =
 [http://docs.themeisle.com/article/743-where-can-i-find-the-import-posts-options-in-feedzy](http://docs.themeisle.com/article/743-where-can-i-find-the-import-posts-options-in-feedzy)

 = How to use WordAI to Rephrase RSS content in Feedzy =
 [http://docs.themeisle.com/article/746-how-to-use-wordai-to-rephrase-rss-content-in-feedzy](http://docs.themeisle.com/article/746-how-to-use-wordai-to-rephrase-rss-content-in-feedzy)

 = Install and use the premium version of Feedzy RSS Feeds =
 [http://docs.themeisle.com/article/783-install-and-use-the-premium-version-of-feedzy-rss-feeds](http://docs.themeisle.com/article/783-install-and-use-the-premium-version-of-feedzy-rss-feeds)

 = Feedzy RSS Feeds Documentation =
 [https://docs.themeisle.com/article/658-feedzy-rss-feeds-documentation](https://docs.themeisle.com/article/658-feedzy-rss-feeds-documentation)

 = What actions and filters are available in Feedzy =
 [https://docs.themeisle.com/article/540-what-actions-and-filters-are-available-in-feedzy](https://docs.themeisle.com/article/540-what-actions-and-filters-are-available-in-feedzy)

 = How to change thumbs size and aspect ratio Feedzy =
 [https://docs.themeisle.com/article/551-how-to-change-thumbs-size-and-aspect-ratio-feedzy](https://docs.themeisle.com/article/551-how-to-change-thumbs-size-and-aspect-ratio-feedzy)

 = How to display RSS feed time and date in local time =
 [https://docs.themeisle.com/article/567-how-to-display-rss-feed-time-and-date-in-local-time](https://docs.themeisle.com/article/567-how-to-display-rss-feed-time-and-date-in-local-time)

 = How to add a read more link to Feedzy =
 [https://docs.themeisle.com/article/544-how-to-add-a-read-more-link-to-feedzy](https://docs.themeisle.com/article/544-how-to-add-a-read-more-link-to-feedzy)

 = How to use feedzy categories =
 [https://docs.themeisle.com/article/640-how-to-use-feedzy-categories](https://docs.themeisle.com/article/640-how-to-use-feedzy-categories)

 = How to use your own inline css =
 [https://docs.themeisle.com/article/546-how-to-use-your-own-inline-css](https://docs.themeisle.com/article/546-how-to-use-your-own-inline-css)

 = How to change cache lifetime for a specific feed =
 [https://docs.themeisle.com/article/547-how-to-change-cache-lifetime-for-a-specific-feed](https://docs.themeisle.com/article/547-how-to-change-cache-lifetime-for-a-specific-feed)

 = How to remove featured image from blog feed =
 [https://docs.themeisle.com/article/554-how-to-remove-featured-image-from-blog-feed](https://docs.themeisle.com/article/554-how-to-remove-featured-image-from-blog-feed)

 = How to handle publication date and author content =
 [https://docs.themeisle.com/article/549-how-to-handle-publication-date-and-author-content](https://docs.themeisle.com/article/549-how-to-handle-publication-date-and-author-content)

 = How to keep html in feed items content =
 [https://docs.themeisle.com/article/542-how-to-keep-html-in-feed-items-content](https://docs.themeisle.com/article/542-how-to-keep-html-in-feed-items-content)

 = How to fix images that are not showing in the feed =
 [https://docs.themeisle.com/article/666-how-to-fix-images-that-are-not-showing-in-the-feed](https://docs.themeisle.com/article/666-how-to-fix-images-that-are-not-showing-in-the-feed)

 = How to display items in a random order =
 [https://docs.themeisle.com/article/550-how-to-display-items-in-a-random-order](https://docs.themeisle.com/article/550-how-to-display-items-in-a-random-order)

 = How to remove links =
 [https://docs.themeisle.com/article/541-how-to-remove-links](https://docs.themeisle.com/article/541-how-to-remove-links)

 = How to move Feedzy templates to your theme =
 [https://docs.themeisle.com/article/573-how-to-move-feedzy-templates-to-your-theme](https://docs.themeisle.com/article/573-how-to-move-feedzy-templates-to-your-theme)

 = How to remove plugin css =
 [https://docs.themeisle.com/article/545-how-to-remove-plugin-css](https://docs.themeisle.com/article/545-how-to-remove-plugin-css)

 = How to remove time from publication date =
 [https://docs.themeisle.com/article/553-how-to-remove-time-from-publication-date](https://docs.themeisle.com/article/553-how-to-remove-time-from-publication-date)

 = How to remove the end hellip =
 [https://docs.themeisle.com/article/543-how-to-remove-the-end-hellip](https://docs.themeisle.com/article/543-how-to-remove-the-end-hellip)

 = How to decode item title =
 [https://docs.themeisle.com/article/548-how-to-decode-item-title](https://docs.themeisle.com/article/548-how-to-decode-item-title)

 = How to sort feed items by title =
 [https://docs.themeisle.com/article/633-how-to-sort-feed-items-by-title](https://docs.themeisle.com/article/633-how-to-sort-feed-items-by-title)

 = How to import posts from feeds in Feedzy =
 [https://docs.themeisle.com/article/742-how-to-import-posts-from-feeds-in-feedzy](https://docs.themeisle.com/article/742-how-to-import-posts-from-feeds-in-feedzy)

 = How to change author url =
 [https://docs.themeisle.com/article/636-how-to-change-author-url](https://docs.themeisle.com/article/636-how-to-change-author-url)

 = How to eliminate duplicate feed items. =
 [https://docs.themeisle.com/article/638-how-to-eliminate-duplicate-feed-items](https://docs.themeisle.com/article/638-how-to-eliminate-duplicate-feed-items)

 = How to check whether the RSS feed is valid or not in Feedzy =
 [https://docs.themeisle.com/article/716-how-to-check-whether-the-rss-feed-is-valid-or-not-in-feedzy](https://docs.themeisle.com/article/716-how-to-check-whether-the-rss-feed-is-valid-or-not-in-feedzy)

 = How to change the blacklist image name =
 [https://docs.themeisle.com/article/552-how-to-change-the-blacklist-image-name](https://docs.themeisle.com/article/552-how-to-change-the-blacklist-image-name)

 = How to use proxy settings in Feedzy =
 [https://docs.themeisle.com/article/714-how-to-use-proxy-settings-in-feedzy](https://docs.themeisle.com/article/714-how-to-use-proxy-settings-in-feedzy)

 = Where can I find the import posts options in Feedzy =
 [https://docs.themeisle.com/article/743-where-can-i-find-the-import-posts-options-in-feedzy](https://docs.themeisle.com/article/743-where-can-i-find-the-import-posts-options-in-feedzy)

 = How to change user agent in Feedzy =
 [https://docs.themeisle.com/article/713-how-to-change-user-agent-in-feedzy](https://docs.themeisle.com/article/713-how-to-change-user-agent-in-feedzy)

 = How to use WordAI to Rephrase RSS content in Feedzy =
 [https://docs.themeisle.com/article/746-how-to-use-wordai-to-rephrase-rss-content-in-feedzy](https://docs.themeisle.com/article/746-how-to-use-wordai-to-rephrase-rss-content-in-feedzy)

 = Install and use the premium version of Feedzy RSS Feeds =
 [https://docs.themeisle.com/article/783-install-and-use-the-premium-version-of-feedzy-rss-feeds](https://docs.themeisle.com/article/783-install-and-use-the-premium-version-of-feedzy-rss-feeds)

 = How to sort feed items by date =
 [https://docs.themeisle.com/article/817-how-to-sort-feed-items-by-date](https://docs.themeisle.com/article/817-how-to-sort-feed-items-by-date)

 = How to add rel="nofollow" to feed links =
 [https://docs.themeisle.com/article/839-how-to-add-relnofollow-to-feed-links](https://docs.themeisle.com/article/839-how-to-add-relnofollow-to-feed-links)

 = What to do when you get Warning: ./cache is not writeable =
 [https://docs.themeisle.com/article/840-what-to-do-when-you-get-warning-cache-is-not-writeable](https://docs.themeisle.com/article/840-what-to-do-when-you-get-warning-cache-is-not-writeable)

 = How to exclude feeds with certain words in it =
 [https://docs.themeisle.com/article/850-how-to-exclude-feeds-with-certain-words-in-it](https://docs.themeisle.com/article/850-how-to-exclude-feeds-with-certain-words-in-it)

 = How to add canonical tags for imported posts =
 [https://docs.themeisle.com/article/841-how-to-add-canonical-tags-for-imported-posts](https://docs.themeisle.com/article/841-how-to-add-canonical-tags-for-imported-posts)

 = How to display thumbnail image from the feeds =
 [https://docs.themeisle.com/article/871-how-to-display-thumbnail-image-from-the-feeds](https://docs.themeisle.com/article/871-how-to-display-thumbnail-image-from-the-feeds)

 = How to change feed items order =
 [https://docs.themeisle.com/article/864-how-to-change-feed-items-order](https://docs.themeisle.com/article/864-how-to-change-feed-items-order)

 = How to use WordAI or SpinnerChief to Rephrase RSS content in Feedzy =
 [https://docs.themeisle.com/article/746-how-to-use-wordai-or-spinnerchief-to-rephrase-rss-content-in-feedzy](https://docs.themeisle.com/article/746-how-to-use-wordai-or-spinnerchief-to-rephrase-rss-content-in-feedzy)

 = How to add affiliate referrals to feed URLs in Feedzy =
 [https://docs.themeisle.com/article/715-how-to-add-affiliate-referrals-to-feed-urls-in-feedzy](https://docs.themeisle.com/article/715-how-to-add-affiliate-referrals-to-feed-urls-in-feedzy)

 = How price is displayed from the feed =
 [https://docs.themeisle.com/article/923-how-price-is-displayed-from-the-feed](https://docs.themeisle.com/article/923-how-price-is-displayed-from-the-feed)

 = How to find Feed URL for Feedzy RSS Feeds =
 [https://docs.themeisle.com/article/799-how-to-find-feed-url-for-feedzy-rss-feeds](https://docs.themeisle.com/article/799-how-to-find-feed-url-for-feedzy-rss-feeds)

 = In Feedzy how do I... =
 [https://docs.themeisle.com/article/942-in-feedzy-how-do-i](https://docs.themeisle.com/article/942-in-feedzy-how-do-i)

 = How to import iTunes audio feed =
 [https://docs.themeisle.com/article/1041-how-to-import-itunes-audio-feed](https://docs.themeisle.com/article/1041-how-to-import-itunes-audio-feed)

 = Feedzy RSS Feeds Documentation =
 [https://docs.themeisle.com/article/658-feedzy-rss-feeds](https://docs.themeisle.com/article/658-feedzy-rss-feeds)

 = How to check whether the RSS feed is valid or not in Feedzy =
 [https://docs.themeisle.com/article/716-feedzy-how-to-check-whether-the-rss-feed-is-valid-or-not](https://docs.themeisle.com/article/716-feedzy-how-to-check-whether-the-rss-feed-is-valid-or-not)

 = How to change thumbs size and aspect ratio Feedzy =
 [https://docs.themeisle.com/article/551-how-to-change-thumbs-size-and-aspect-ratio](https://docs.themeisle.com/article/551-how-to-change-thumbs-size-and-aspect-ratio)

 = How to use proxy settings in Feedzy =
 [https://docs.themeisle.com/article/714-how-to-use-proxy-settings-in-feezy](https://docs.themeisle.com/article/714-how-to-use-proxy-settings-in-feezy)

 = How to decode item title =
 [https://docs.themeisle.com/article/548-how-to-decode-item-title-with](https://docs.themeisle.com/article/548-how-to-decode-item-title-with)

 = How to add affiliate referrals to feed URLs in Feedzy =
 [https://docs.themeisle.com/article/715-feedzy-how-to-add-affiliate-referrals-to-feed-urls](https://docs.themeisle.com/article/715-feedzy-how-to-add-affiliate-referrals-to-feed-urls)

 = How to add rel="nofollow" to feed links =
 [https://docs.themeisle.com/article/839-how-to-add-rel-nofollow-to-feed-links](https://docs.themeisle.com/article/839-how-to-add-rel-nofollow-to-feed-links)

 = How to import iTunes audio feed =
 [https://docs.themeisle.com/article/1041-import-itunes-audio-feed](https://docs.themeisle.com/article/1041-import-itunes-audio-feed)

 = How to link featured image to original post in Slider Revolution =
 [https://docs.themeisle.com/article/1069-how-to-link-featured-image-to-original-post-in-slider-revolution](https://docs.themeisle.com/article/1069-how-to-link-featured-image-to-original-post-in-slider-revolution)

 = How to display author, date, time (or a combination) from the feed =
 [https://docs.themeisle.com/article/1089-how-to-display-author-date-or-time-from-the-feed](https://docs.themeisle.com/article/1089-how-to-display-author-date-or-time-from-the-feed)

 = How to get videos from YouTube with Feedzy =
 [https://docs.themeisle.com/article/1113-how-to-get-videos-from-youtube-with-feedzy](https://docs.themeisle.com/article/1113-how-to-get-videos-from-youtube-with-feedzy)

 = Feedzy RSS Feeds Documentation =
 [https://docs.themeisle.com/article/1119-feedzy-rss-feeds-documentation](https://docs.themeisle.com/article/1119-feedzy-rss-feeds-documentation)

 = How to use Feed to Post feature in Feedzy =
 [https://docs.themeisle.com/article/1154-how-to-use-feed-to-post-feature-in-feedzy](https://docs.themeisle.com/article/1154-how-to-use-feed-to-post-feature-in-feedzy)

 = Feedzy Troubleshooting Guide =
 [https://docs.themeisle.com/article/1155-feedzy-troubleshooting-guide](https://docs.themeisle.com/article/1155-feedzy-troubleshooting-guide)

 = How to use Feedzy with a shortcode =
 [https://docs.themeisle.com/article/1130-how-to-use-feedzy-with-a-shortcode](https://docs.themeisle.com/article/1130-how-to-use-feedzy-with-a-shortcode)

 = Feedzy custom templates =
 [https://docs.themeisle.com/article/1162-feedzy-custom-templates](https://docs.themeisle.com/article/1162-feedzy-custom-templates)

 = How to change the date format RSS items in Feedzy =
 [https://docs.themeisle.com/article/1200-how-to-change-the-date-format-for-rss-items-in-feedzy](https://docs.themeisle.com/article/1200-how-to-change-the-date-format-for-rss-items-in-feedzy)

 = Lazy loading feed items with Feedzy =
 [https://docs.themeisle.com/article/1220-lazy-loading-feed-items-with-feedzy](https://docs.themeisle.com/article/1220-lazy-loading-feed-items-with-feedzy)

 = How to install and activate Feedzy Pro =
 [https://docs.themeisle.com/article/1247-how-to-install-and-activate-feedzy-pro](https://docs.themeisle.com/article/1247-how-to-install-and-activate-feedzy-pro)

 == Screenshots ==

1. Add categories
2. Import settings
3. General settings
4. Simple example
5. Imported feeds
6. Widget admin
7. Widget render

 == Changelog ==
### 3.5.2 - 2020-12-24  ###

* [Fix] Compatibility with WP 5.6
* [Fix] Composer requiring PHP greater than 7.1.0


### 3.5.1 - 2020-10-30  ###

* [Fix] Importing random images with https://source.unsplash.com/random generator link in Feed to Post
* [Fix] Importing fixed featured image in Feed to Post
* [Fix] Enclosures that do no specify image extension are not imported even if the type is image/jpeg


### 3.5.0 - 2020-10-12  ###

* [Feat] Improved interface for adding new imports and for the imports listing page
* [Feat] Improved checks for feeds validity


### 3.4.3 - 2020-08-26  ###

* [Fix] HTML tags being trimmed on save of the import job
* [Fix] Issue with nonce not being checked correctly


### 3.4.2 - 2020-08-12  ###

* - [Fix] Compatibility with WP 5.5
* - [Feat] Link to items imported across runs in Feed2Post



### 3.4.1 - 2020-07-23  ###

* - [Feat] Feed2Post - Provide more info on imported content and possible errors
* - [Feat] Feed2Post - New Purge & Reset button which allows to clear data of already imported items to reimport those again
* - [Fix] Feed2Post - Change cache time to 55 minutes that new items can be imported in the next run
* - [Fix] Conflict with Ultimate CSV Importer
* - [Fix] Sync item image options between classic and block editor
* - [Fix] Posts keeps "uncategorized" category in non-English sites

### 3.4.0 - 2020-05-28  ###

* - [Feat] Options to import feeds to posts
* - [Feat] New [#item_source] tag for Feed to Post to display the feed source name
* - [Feat] Improved Settings page style and layout
* - [Feat] Use SimplePieItem's get_id to determine the uniqueness of feed items
* - [Fix] WP 5.4 Feedzy block compatibility
* - [Fix] Feed Caching time stuck to 12 hours
* - [Fix] PHP Notice: Undefined index errors in the widget
* - [Fix] Bulk activation of plugin aborts activation of subsequent plugins
* - [Fix] Wrong shortcode mentioned in the Support tab
* - [Fix] Notice: Undefined index: host when item has no link element


### 3.3.19 - 2020-04-08  ###

* Tested up to 5.4


### 3.3.18 - 2020-03-24  ###

* [Feat] Add support for lazyloading feed items
* [Fix] multiple_meta and offset parameters in the Feedzy widget
* [Fix] Missing Feedzy button in the Classic editor in Gutenberg
* [Fix] Conflict with RSS Aggregator in the Gutenberg editor
* [Fix] Notices when using Avada theme
* [Fix] Warnings when using multiple feeds in the shortcode


### 3.3.17 - 2020-01-30  ###

* Release



### 3.3.16 - 2020-01-07  ###

* Fix fatal error with new version of SimplePie
* Allow user to dictate order of meta data
* Do not use force_feed for multi feeds

### 3.3.15 - 2020-01-01  ###

* fix Gutenberg bug that limits max items per feed

### 3.3.14 - 2019-12-31  ###

* Show detailed error message to logged in users if feed is not working
* Add offset parameter to skip items in a feed
* When using multiple sources, optionally show feed title
* Fix support for additional class(es) in Gutenberg

### 3.3.13 - 2019-11-30  ###

* Scrub item titles for HTML entities
* Fix widget to use all settings configured
* Fix issue with saving description length

### 3.3.12 - 2019-11-11  ###

* Tested up to 5.3

### 3.3.11 - 2019-09-24  ###

* Fix issue with replacing ellipsis
* Fix issue in widget where error message cannot be overridden
* Fix issues with some summaries getting truncated


### 3.3.10 - 2019-08-20  ###

* Fix issue with undefined index: proxy


### 3.3.9 - 2019-08-13  ###

* Fix PHP notice that shows up if meta=no


### 3.3.8 - 2019-08-12  ###

* - Fix issue with AMP pages not showing image
* - In the short code, separate behavior of meta into author, date and time
* - Add option to remove title entirely
* - Don't show [...] if summary is shorter than required
* - Add option to use default sorting when generating the short code
* - Add ability to show date/time in local timezone


### 3.3.7 - 2019-06-15  ###

* Fix: Not working in the block editor
* Feat: Referral URL can now include the URL of the item as a parameter
* Fix: Image size on mobile was overflowing the viewport
* Fix: Shortcode builder icon not visible in classic editor
* Fix: Widget options not visible in theme customizer


### 3.3.6 - 2019-05-03  ###

* Add filter to disable DB caching
* Fix issue with HTML tags not closed when feed has no items
* Fix issue with CSS file being loaded everywhere
* Tested up to WP 5.2


### 3.3.5 - 2019-02-24  ###

* Tested with WP 5.1
* Fix issue with single feeds that have errors


### 3.3.4 - 2019-02-08  ###

* Multifeed shows an error and no content if even one feed has an error


### 3.3.3 - 2019-01-31  ###

* Customize error message when no items in the feed
* Outgoing links should have rel=noopener
* Fixed fatal error in Feedzy_Rss_Feeds_Admin_Abstract::feedzy_retrieve_image


### 3.3.2 - 2018-12-22  ###

* Option to handle HTTP images in the shortcode
* Option to specify nofollow for links in the shortcode
* Fix Gutenberg block
* Add video tutorials under Help menu
* Add support for extracting price from custom feed tags


### 3.3.1 - 2018-11-05  ###

* Import Posts enabled for plan 1 users
* Fixed issue with some idiosyncratic feeds


### 3.3.0 - 2018-08-21  ###

* Improve readme plugin description.
* Improves compatibility with Gutenberg plugin.
* Improves image detection from feeds.


### 3.2.12 - 2018-08-16  ###

* Fixed compatibility with the Gutenberg block
* Added option to disable the featured image from being added to the website RSS feed
* Fixed problem with excluding keywords not working
* Updated the readme file


### 3.2.11 - 2018-06-26  ###

* New Gutenberg block for Feedzy RSS Feeds
* Fixed curl SSL problem with Feeds with HTTPS
* Fix content type, conflicting with Gutenberg
* Added compatibility with the pro version for full text import


### 3.2.10 - 2018-04-02  ###

* Adds shortcode attribute for feed items order ( title ASC/DESC, date ASC/DESC).
* Improve documentation and examples.


### 3.2.9 - 2018-03-07  ###

* Automatically fix deprecated google  news feeds.
* Improve compatibility with the pro version.


### 3.2.8 - 2018-02-20  ###

* Fix issue with medium feeds.
* Improves extensibility using various hooks.
* Fix feeds without schema protocol.


### 3.2.7 - 2018-01-05  ###

* Fix compatibility with SiteOrigin Page Builder.
* Adds full content import from feed.
* Fix issue with img scraped from articles.


### 3.2.6 - 2017-11-16  ###

* Adds compatibility with WordPress 4.9


### 3.2.5 - 2017-11-03  ###
 * Fix for double slash issue in image path.
 * Fix for private ips when proxy is used.
 * Add FAQ in sync with helpscout docs.



### 3.2.4 - 2017-10-13  ###

* Fix for assets enqueue, loading them where are needed only.
* Removes duplicates readme.md files.


### 3.2.1 - 2017-10-12  ###

* Adds global settings page.
* Adds User Agent and Proxy settings.
* Fix for some edge cases regarding images in the feed.


### 3.2.0 - 2017-08-17  ###

* Fix for image URL issue following some strange patterns.
* Added fallback for broken feed, now if one feed from the list is not working, others will will be used.
* Added shortcode parameter for feed cache control.


### 3.1.10 - 2017-08-03  ###

* Fixed typos in shortcode builder.
* Fixed image encoding issue.


### 3.1.9 - 2017-07-21  ###

* Fixed issue with fetching images containg GET parameters.


### 3.1.8 - 2017-07-17  ###

* Fixed image fetching issues.
* Fixed link opening behaviour
* Improved description ( Thanks to @chesio )


### 3.1.7 ###

* Added new sdk logic.
* Improved compatibility with the pro version.



### 3.1.5 - 30/05/2017 ###
* Fixed issues with sdk notifications.
* Added more compatibility with pro version.

### 3.1.4 - 29/05/2017 ###
* Added new doc on how to use feedzy categories.

### 3.1.3 - 29/05/2017 ###
* Added new SDK features.
* Fixed some edge case issues on image parsing.

### 3.1.2 - 22/05/2017 ###
* Fixed author protocol.
* Added core fetch_feed method.

### 3.1.1 - 22/05/2017 ###
* Fixed span alt tag, replaced with title.

### 3.1.0 - 17/05/2017 ###
* Added feed categories for grouping urls.
* Added support for feed to post feature.
* Fixed regex for jpeg image ( Reported by @piccart )
* Added filter for author url ( Thanks to @piccart )

### 3.0.10 - 24/04/2017 ###
* Fixed wrong image regex.
* Fixed image compression.

### 3.0.9 - 21/02/2017 ###
* Added wrong feed title check.

### 3.0.8 - 20/02/2017 ###
* Added $sizes param to feedzy_thumb_output.
* Added check when title is empty.
* Fixed image encoding url.

### 3.0.6 - 27/01/2017 ###
* Added feedzy_feed_timestamp filter.
* Fixed issue with edge cases feed urls.
* Fixed error when using [] on string vars.


### 3.0.5 - 06/01/2017 ###
* Fixed issue with google news feed

### 3.0.4 - 06/01/2017 ###
* Fixed thumb='auto' behaviour

### 3.0.3 - 06/01/2017 ###
* Fixed blog feed feature image filter
* Improved documentation and examples

### 3.0.2 - 06/01/2017 ###
* Fixed default class  back

### 3.0.1 - 05/01/2017 ###
* Fixed html markup error which was breaking user websites

### 3.0.0 - 10/11/2016 ###
* Refactored code base from 2.8.1 to OOP style
* Added support for PRO version
* Added new hooks feedzy_item_filter, feedzy_item_url_filter


### 2.8 - 04/14/2016 ###
* Tested on WP 4.5 with success!
* themeisle added as plugin author
* Fix a PHP7 warning in the widget contructor regarding [this topic](https://wordpress.org/support/topic/php7-debug-error?replies=1)

### 2.7.1 ###
* Remove unnecessary and redundant feedzy_wp_widget_box div container in the widget's body
* Best compliance with WordPress coding standards
* Fix a PHP warning on SimplePie error display & log
* Readme.txt update

### 2.7 ###
* Better displaying of fetching feeds errors (see error message div error-attr).
* Write errors in the WP log file
* New hook: feedzy_default_error to filter error message
* New hook: shortcode_atts_feedzy_default to filter default shortcode attibutes
* Add a link to validate feed in the TinyMCE popup modal
* French translation update
* Remove unnecessary functions
* New constant FEEDZY_VERSION
* readme.txt and hooks documentation update

### 2.6.2 ###
* Spanish translation thanks to [Angel Calzado](http://sintaxisweb.es "Angel Calzado")
* PHP issue fix in feedzy_returnImage() "strpos() expects parameter 1 to be string"
* Remove SSL from feeds URL to prevent fetching errors
* New hook: feedzy_default_image
* readme.txt and hooks documentation update

### 2.6.1 ###
* Replace jQuery live() function by on() function to prevent JS error (fix the issue with Visual composer)
* Improve image's fetching on itunes feeds
* New feature: default WP smilies are now blacklisted from image fetching
* New hook: feedzy_feed_blacklist_images
* Tested on WP 4.3 with success!

### 2.6 ###
* Fix a conflict with PageBuilder where Feedzy button does not show up in the visual editor
* Fix a typo in feedzy-rss-feeds-shortcode.php on the thumbnails span
* Replace WP_Widget by __construct() to initiate the widget because it has been deprecated since version 4.3.0
* German translation thanks to [ralfsteck](https://profiles.wordpress.org/ralfsteck/ "ralfsteck")
* Tested on WP 4.3 with success!

### 2.5.1 ###
* Japanese translation thanks to [sama55](http://askive.cmsbox.jp/ "sama55")
* Image optimisation (feedzy-default.jpg)
* Improve image's fetching to avoid catching audio or video files from item description

### 2.5 ###
* Improve author name fetching
* Better HTML marckup
* Fix PHP warning within the widget
* Fix CSS on IE when displaying images as a fallback
* CSS stylesheet update
* New hook: feedzy_item_attributes

### 2.4.3 ###
* Improve image fetching (again...)
* Fix an issue on files encoding (UTF8)
* Minor PHP improvements on the main shortcode's function

### 2.4.2 ###
* Minor fix on already encoded images names

### 2.4.1 ###
* Fix an issue on img url encode
* Retrive img url in url parameters
* Fix minor PHP warning
* New hook: feedzy_add_classes_item

### 2.4 ###
* New feature: 'auto' thumbs option added
* New hook: feedzy_thumb_sizes
* Fix issue on max number of feeds to display
* Fix HTML decode in the feed's title
* Minor PHP improvements
* readme.txt and hooks documentation update

### 2.3 ###
* New hook: feedzy_feed_items
* New hook: feedzy_item_keyword
* Introduce SimplePie native strip_htmltags() method
* Use PNG icon as SVG fallback on the visual editor button
* Improve plugin's files structure
* readme.txt and hooks documentation update

### 2.2.2 ###
* New hook: feedzy_meta_args

### 2.2.1 ###
* Minor security improvements
* Better WordPress coding standard respect
* Minor fix if does not provide item's author
* Translations update

### 2.2 ###
* Minor PHP improvements
* Remove logo from plugin meta
* New hook: feedzy_summary_input
* $feedURL argument added on every available hooks
* French translation update
* readme.txt and hooks documentation update

### 2.1 ###
* internationalization of feeds dates and times (date_i18n)

### 2.0 ###
* Widget added
* Translation update
* Better plugin file structure
* Improve image fetching with multiple enclosures
* Tested on WP 4.1 with success!

### 1.7.1 ###
* Fix typo in PHP which cause issue on fetching images

### 1.7 ###
* Minor Template and CSS changes
* New hook: feedzy_thumb_output
* New hook: feedzy_title_output
* New hook: feedzy_meta_output
* New hook: feedzy_summary_output
* New hook: feedzy_global_output
* readme.txt update

### 1.6 ###
* Minor CSS fix
* Add actions: add_action('rss_item', 'feedzy_include_thumbnail_RSS'); & add_action('rss2_item', 'feedzy_include_thumbnail_RSS')

### 1.5.4 ###
* Plugin meta translation
* Remove unnecessary spaces

### 1.5.3 ###
* TinyMCE UI translation
* Better fetching image
* Space between items is calculated based on thumbs size

### 1.5.2 ###
* Plugin meta update

### 1.5.1 ###
* New logo
* Minor CSS fixes

### 1.5 ###
* New param added to filter item with keywords
* Default thumb added
* Fix minor php issue
* Rename files of the plugin
* New logo + screenshot (assets)

### 1.4 ###
* Add "default" parameter to fill image container if no image is fetch or if it is offline
* Add more control over numeric format in max, size, title & summarylength parameters

### 1.03 ###
* Shortcode can now be displayed everywhere in the page (CSS is loaded via global var)

### 1.02 ###
* Error on svn tag

### 1.01 ###
* Minor CSS fix.
* Minor PHP changes.
* Readme.txt updated

### 1.0 ###
* First release.

## Upgrade Notice ##

### 1.5 ###
* IMPORTANT: You have to reactivate the plugin after its update!

### 1.0 ###
* First release.
