<!--
Layout For Document Page of Feedzy RSS Feeds

@since    3.0.12
@package  feedzy-rss-feeds
-->

<?php
	$is_pro = feedzy_is_pro();
?>

<div class="fz-document-list">
	<ul>
		<li>
			<div class="fz-document-box">
				<div class="fz-document-box-img">
					<img src="<?php echo esc_url( FEEDZY_ABSURL . 'img/feed-to-post.jpg' ); ?>" alt="">
				</div>
				<div class="fz-document-box-content">
					<h3 class="h3">Feed to Post</h3>
					<p>Learn how to convert feed items into Posts, Pages, or any custom post type.</p>
					<div class="cta">
						<a href="https://docs.themeisle.com/article/1154-how-to-use-feed-to-post-feature-in-feedzy" class="btn btn-outline-primary" target="_blank">Learn more</a>
					</div>
				</div>
			</div>
		</li>
		<li>
			<div class="fz-document-box">
				<div class="fz-document-box-img">
					<img src="<?php echo esc_url( FEEDZY_ABSURL . 'img/shortcode.jpg' ); ?>" alt="">
				</div>
				<div class="fz-document-box-content">
					<h3 class="h3">Shortcode</h3>
					<p>Learn how to display feed items using the [feedzy-rss] shortcode in a few easy steps.</p>
					<div class="cta">
						<a href="https://docs.themeisle.com/article/1130-how-to-use-feedzy-with-a-shortcode" class="btn btn-outline-primary" target="_blank">Learn more</a>
					</div>
				</div>
			</div>
		</li>
		<li>
			<div class="fz-document-box">
				<div class="fz-document-box-img">
					<img src="<?php echo esc_url( FEEDZY_ABSURL . 'img/rephrase-feeds-content.jpg' ); ?>" alt="">
				</div>
				<div class="fz-document-box-content">
					<h3 class="h3">Rephrase Feeds content</h3>
					<p>Learn how to use WordAi and SpinnerChief  to rephrase RSS feeds content.</p>
					<div class="cta">
						<a href="https://docs.themeisle.com/article/746-how-to-use-wordai-to-rephrase-rss-content-in-feedzy" class="btn btn-outline-primary" target="_blank">Learn more</a>
					</div>
				</div>
			</div>
		</li>
		<li>
			<div class="fz-document-box">
				<div class="fz-document-box-img">
					<img src="<?php echo esc_url( FEEDZY_ABSURL . 'img/validate-RSS-feed.jpg' ); ?>" alt="">
				</div>
				<div class="fz-document-box-content">
					<h3 class="h3">How to validate a RSS feed </h3>
					<p>Learn how to check if a RSS feed is valid or not in Feedzy.</p>
					<div class="cta">
						<a href="https://docs.themeisle.com/article/716-feedzy-how-to-check-whether-the-rss-feed-is-valid-or-not" class="btn btn-outline-primary" target="_blank">Learn more</a>
					</div>
				</div>
			</div>
		</li>
		<li>
			<div class="fz-document-box">
				<div class="fz-document-box-img">
					<img src="<?php echo esc_url( FEEDZY_ABSURL . 'img/feedzy-demo.jpg' ); ?>" alt="">
				</div>
				<div class="fz-document-box-content">
					<h3 class="h3">Feedzy Demo</h3>
					<p>See how Feedzy can integrate with your website by browsing our examples.</p>
					<div class="cta">
						<a href="https://demo.themeisle.com/feedzy-rss-feeds/" class="btn btn-outline-primary" target="_blank">Learn more</a>
					</div>
				</div>
			</div>
		</li>
		<li>
			<div class="fz-document-box">
				<div class="fz-document-box-img">
					<img src="<?php echo esc_url( FEEDZY_ABSURL . 'img/in-feedzy.jpg' ); ?>" alt="">
				</div>
				<div class="fz-document-box-content">
					<h3 class="h3">In Feedzy how do I...</h3>
					<p>Learn some of the most popular hooks you can use with the Feedzy plugin.</p>
					<div class="cta">
						<a href="https://docs.themeisle.com/article/942-in-feedzy-how-do-i" class="btn btn-outline-primary" target="_blank">Learn more</a>
					</div>
				</div>
			</div>
		</li>
	</ul>
	<div class="cta">
		<a href="https://docs.themeisle.com/category/712-feedzy" class="btn btn-ghost" target="blank">Open Feedzy Documentation page</a>
	</div>
</div>
